/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.ConstantPoolRefs;
import org.wildfly.extras.transformer.nodeps.Utf8InfoMapping;

final class Utf8ItemsPatch {
    final int diffInBytes;
    final List<int[]> utf8ItemPatches;

    private Utf8ItemsPatch(int diffInBytes, List<int[]> utf8ItemPatches) {
        this.diffInBytes = diffInBytes;
        this.utf8ItemPatches = utf8ItemPatches;
    }

    static Utf8ItemsPatch of(byte[] clazz, ConstantPoolRefs cpRefs, Utf8InfoMapping utf8Mapping) {
        int diffInBytes = 0;
        ArrayList<int[]> utf8ItemPatches = null;
        for (int i = 1; i < cpRefs.getSize(); ++i) {
            int[] patch;
            if (!cpRefs.isUtf8(i) || (patch = Utf8ItemsPatch.getUtf8Patch(clazz, cpRefs, i, utf8Mapping)) == null) continue;
            if (utf8ItemPatches == null) {
                utf8ItemPatches = new ArrayList<int[]>(ClassFileUtils.countUtf8Items(cpRefs));
            }
            diffInBytes += patch[1];
            utf8ItemPatches.add(patch);
        }
        return utf8ItemPatches != null ? new Utf8ItemsPatch(diffInBytes, utf8ItemPatches) : null;
    }

    private static int[] getUtf8Patch(byte[] clazz, ConstantPoolRefs cpRefs, int cpIndex, Utf8InfoMapping mapping) {
        int utf8Length = cpRefs.getUtf8_Length(cpIndex);
        int offset = cpRefs.getUtf8_BytesRef(cpIndex);
        int limit = offset + utf8Length;
        int[] retVal = null;
        int patchIndex = 2;
        for (int i = offset; i <= limit - mapping.min; ++i) {
            for (int j = 1; j < mapping.from.length; ++j) {
                if (limit - i < mapping.from[j].length) continue;
                int mappingIndex = j;
                for (int k = 0; k < mapping.from[j].length; ++k) {
                    if (clazz[i + k] == mapping.from[j][k]) continue;
                    mappingIndex = 0;
                    break;
                }
                if (mappingIndex == 0) continue;
                if (retVal == null) {
                    retVal = new int[((limit - i) / mapping.min + 1) * 2];
                    retVal[0] = cpIndex;
                }
                retVal[patchIndex++] = mappingIndex;
                retVal[patchIndex++] = i - offset;
                retVal[1] = retVal[1] + (mapping.to[mappingIndex].length - mapping.from[mappingIndex].length);
                i += mapping.from[j].length;
            }
        }
        return retVal;
    }
}

