/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ConstantPoolRefs;

final class ClassFileUtils {
    private ClassFileUtils() {
    }

    static int readUnsignedShort(byte[] clazz, int offset) {
        return (clazz[offset] & 0xFF) << 8 | clazz[offset + 1] & 0xFF;
    }

    static int readUnsignedInt(byte[] clazz, int offset) {
        return (clazz[offset] & 0xFF) << 24 | (clazz[offset + 1] & 0xFF) << 16 | (clazz[offset + 2] & 0xFF) << 8 | clazz[offset + 3] & 0xFF;
    }

    static void writeUnsignedShort(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value >>> 8);
        buffer[offset + 1] = (byte)value;
    }

    static void writeUnsignedInt(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value >>> 24);
        buffer[offset + 1] = (byte)(value >>> 16);
        buffer[offset + 2] = (byte)(value >>> 8);
        buffer[offset + 3] = (byte)value;
    }

    static String utf8ToString(byte[] clazz, int offset, int limit) {
        char[] charBuffer = new char[limit - offset];
        int charsCount = 0;
        int index = offset;
        while (index < limit) {
            byte currentByte;
            if (((currentByte = clazz[index++]) & 0x80) == 0) {
                charBuffer[charsCount++] = (char)(currentByte & 0x7F);
                continue;
            }
            if ((currentByte & 0xE0) == 192) {
                charBuffer[charsCount++] = (char)(((currentByte & 0x1F) << 6) + (clazz[index++] & 0x3F));
                continue;
            }
            charBuffer[charsCount++] = (char)(((currentByte & 0xF) << 12) + ((clazz[index++] & 0x3F) << 6) + (clazz[index++] & 0x3F));
        }
        return new String(charBuffer, 0, charsCount);
    }

    static byte[] stringToUtf8(String data) {
        byte[] retVal = new byte[ClassFileUtils.getUtf8Size(data)];
        int bytesCount = 0;
        for (int i = 0; i < data.length(); ++i) {
            char currentChar = data.charAt(i);
            if (currentChar < '\u0080' && currentChar != '\u0000') {
                retVal[bytesCount++] = (byte)currentChar;
                continue;
            }
            if (currentChar >= '\u0800') {
                retVal[bytesCount++] = (byte)(0xE0 | currentChar >> 12 & 0xF);
                retVal[bytesCount++] = (byte)(0x80 | currentChar >> 6 & 0x3F);
                retVal[bytesCount++] = (byte)(0x80 | currentChar >> 0 & 0x3F);
                continue;
            }
            retVal[bytesCount++] = (byte)(0xC0 | currentChar >> 6 & 0x1F);
            retVal[bytesCount++] = (byte)(0x80 | currentChar >> 0 & 0x3F);
        }
        return retVal;
    }

    static int countUtf8Items(ConstantPoolRefs cpRefs) {
        int retVal = 0;
        for (int i = 1; i < cpRefs.getSize(); ++i) {
            if (!cpRefs.isUtf8(i)) continue;
            ++retVal;
        }
        return retVal;
    }

    private static int getUtf8Size(String data) {
        int retVal = data.length();
        for (int i = 0; i < data.length(); ++i) {
            char currentChar = data.charAt(i);
            if (currentChar < '\u0080' && currentChar != '\u0000') continue;
            retVal += currentChar >= '\u0800' ? 2 : 1;
        }
        return retVal;
    }
}

