/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.nodeps;

import org.wildfly.extras.transformer.nodeps.ClassFileUtils;
import org.wildfly.extras.transformer.nodeps.CodeAttributeRefs;
import org.wildfly.extras.transformer.nodeps.ConstantPoolRefs;

final class MethodInfoRefs {
    private final int methodInfoStartRef;
    private final int accessFlagsRef;
    private final int accessFlags;
    private final int nameIndexRef;
    private final int nameIndex;
    private final int descriptorIndexRef;
    private final int descriptorIndex;
    private final int attributesCountRef;
    private final int attributesCount;
    private final int attributesStartRef;
    private final int attributesEndRef;
    private final CodeAttributeRefs codeAttributeRefs;
    private final int methodInfoEndRef;
    private final int index;

    private MethodInfoRefs(byte[] clazz, int methodInfoStartRef, CodeAttributeRefs codeAttributeRefs, int methodInfoEndRef, int index) {
        this.methodInfoStartRef = methodInfoStartRef;
        this.accessFlagsRef = methodInfoStartRef;
        this.accessFlags = ClassFileUtils.readUnsignedShort(clazz, this.accessFlagsRef);
        this.nameIndexRef = this.accessFlagsRef + 2;
        this.nameIndex = ClassFileUtils.readUnsignedShort(clazz, this.nameIndexRef);
        this.descriptorIndexRef = this.nameIndexRef + 2;
        this.descriptorIndex = ClassFileUtils.readUnsignedShort(clazz, this.descriptorIndexRef);
        this.attributesCountRef = this.descriptorIndexRef + 2;
        this.attributesCount = ClassFileUtils.readUnsignedShort(clazz, this.attributesCountRef);
        this.attributesStartRef = this.attributesCountRef + 2;
        this.attributesEndRef = methodInfoEndRef;
        this.codeAttributeRefs = codeAttributeRefs;
        this.methodInfoEndRef = methodInfoEndRef;
        this.index = index;
    }

    int getMethodInfoStartRef() {
        return this.methodInfoStartRef;
    }

    int getAccessFlagsRef() {
        return this.accessFlagsRef;
    }

    int getAccessFlags() {
        return this.accessFlags;
    }

    int getNameIndexRef() {
        return this.nameIndexRef;
    }

    int getNameIndex() {
        return this.nameIndex;
    }

    int getDescriptorIndexRef() {
        return this.descriptorIndexRef;
    }

    int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    int getAttributesCountRef() {
        return this.attributesCountRef;
    }

    int getAttributesCount() {
        return this.attributesCount;
    }

    int getAttributesStartRef() {
        return this.attributesStartRef;
    }

    int getAttributesEndRef() {
        return this.attributesEndRef;
    }

    int getIndex() {
        return this.index;
    }

    CodeAttributeRefs getCodeAttribute() {
        return this.codeAttributeRefs;
    }

    int getMethodInfoEndRef() {
        return this.methodInfoEndRef;
    }

    static MethodInfoRefs of(byte[] clazz, ConstantPoolRefs cpRefs, int methodInfoStartRef, int index) {
        int position = methodInfoStartRef + 6;
        int attributesCount = ClassFileUtils.readUnsignedShort(clazz, position);
        position += 2;
        CodeAttributeRefs codeAttributeRefs = null;
        for (int j = 0; j < attributesCount; ++j) {
            int attributeStartRef = position;
            int attributeNameIndex = ClassFileUtils.readUnsignedShort(clazz, position);
            int attributeLength = ClassFileUtils.readUnsignedInt(clazz, position += 2);
            int attributeEndRef = (position += 4) + attributeLength;
            boolean isCodeAttribute = "Code".equals(cpRefs.getUtf8AsString(attributeNameIndex));
            if (isCodeAttribute) {
                codeAttributeRefs = CodeAttributeRefs.of(clazz, attributeStartRef);
            }
            position = attributeEndRef;
        }
        return new MethodInfoRefs(clazz, methodInfoStartRef, codeAttributeRefs, position, index);
    }
}

