/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.tool.maven;

import java.io.File;
import java.io.IOException;
import org.wildfly.extras.transformer.ArchiveTransformer;
import org.wildfly.extras.transformer.Config;
import org.wildfly.extras.transformer.TransformerBuilder;
import org.wildfly.extras.transformer.TransformerFactory;

final class HandleTransformation {
    public static final String JAR_FILE_EXT = ".jar";

    HandleTransformation() {
    }

    static void transformDirectory(File folder, String packagesMappingFile) throws IOException {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File sourceFile : files) {
            if (sourceFile.isDirectory()) {
                HandleTransformation.transformDirectory(sourceFile, packagesMappingFile);
                continue;
            }
            if (!sourceFile.getName().endsWith(JAR_FILE_EXT)) continue;
            HandleTransformation.transformFile(sourceFile, new File(sourceFile.getParentFile(), sourceFile.getName() + ".transformed"), packagesMappingFile);
        }
    }

    static void transformFile(File sourceFile, File targetFile, String packagesMappingFile) throws IOException {
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("input file " + sourceFile.getName() + " does not exist");
        }
        if (!sourceFile.getName().endsWith(JAR_FILE_EXT)) {
            throw new IllegalArgumentException("Supported file extensions are .jar : " + sourceFile.getAbsolutePath());
        }
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("Couldn't find file " + sourceFile.getAbsolutePath());
        }
        if (sourceFile.getName().endsWith(JAR_FILE_EXT)) {
            TransformerBuilder builder = TransformerFactory.getInstance().newTransformer();
            builder.setConfiguration(Config.PACKAGES_MAPPING, packagesMappingFile);
            ArchiveTransformer transformer = builder.build();
            transformer.transform(sourceFile, targetFile);
        }
    }
}

