/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.tool.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.wildfly.extras.transformer.tool.maven.HandleTransformation;

@Mojo(name="transform-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class SourceTransformerMojo
extends AbstractMojo {
    @Component
    protected MojoExecution execution;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="inputFile")
    private File inputFile;
    @Parameter(name="source-project", property="source.project")
    private File sourceProject;
    @Parameter(defaultValue="${configs.dir}", readonly=true)
    private String configsDir;
    @Parameter(property="overwrite", required=false, defaultValue="false")
    private boolean overwrite;
    @Parameter(required=false, readonly=true)
    private String outputFolder;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block16: {
            LifecyclePhase lifecyclePhase = this.valueOf(this.execution.getLifecyclePhase());
            try {
                if (this.inputFile != null && this.inputFile.isDirectory()) {
                    File outputDir = this.getOutputDirectory(lifecyclePhase);
                    try {
                        this.getLog().info((CharSequence)("Transforming contents of folder " + this.inputFile + " to " + outputDir));
                        HandleTransformation.transformDirectory(this.inputFile, outputDir, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite);
                        switch (lifecyclePhase) {
                            case GENERATE_SOURCES: {
                                this.mavenProject.addCompileSourceRoot(new File(outputDir, this.inputFile.getName()).getAbsolutePath());
                                break;
                            }
                            case GENERATE_TEST_SOURCES: {
                                this.mavenProject.addTestCompileSourceRoot(new File(outputDir, this.inputFile.getName()).getAbsolutePath());
                                break;
                            }
                            case GENERATE_RESOURCES: {
                                Resource resource = new Resource();
                                resource.setDirectory(outputDir.getAbsolutePath());
                                this.mavenProject.addResource(resource);
                                break;
                            }
                            case GENERATE_TEST_RESOURCES: {
                                Resource testResource = new Resource();
                                testResource.setDirectory(outputDir.getAbsolutePath());
                                this.mavenProject.addTestResource(testResource);
                            }
                        }
                        break block16;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException(e.getMessage(), (Exception)e);
                    }
                }
                if (this.sourceProject != null && this.sourceProject.isDirectory()) {
                    File outputDir;
                    this.getLog().info((CharSequence)("Transforming contents of project " + this.sourceProject));
                    Path sourceProjectPath = this.sourceProject.toPath();
                    Path input = sourceProjectPath.resolve("src").resolve("main").resolve("java");
                    if (Files.exists(input, new LinkOption[0]) && Files.isDirectory(input, new LinkOption[0])) {
                        outputDir = this.getOutputDirectory(LifecyclePhase.GENERATE_SOURCES);
                        this.getLog().info((CharSequence)("Transforming contents of folder " + input + " to " + outputDir));
                        HandleTransformation.transformDirectory(input.toFile(), outputDir, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite);
                        this.mavenProject.addCompileSourceRoot(outputDir.getAbsolutePath());
                    }
                    if (Files.exists(input = sourceProjectPath.resolve("src").resolve("test").resolve("java"), new LinkOption[0]) && Files.isDirectory(input, new LinkOption[0])) {
                        outputDir = this.getOutputDirectory(LifecyclePhase.GENERATE_TEST_SOURCES);
                        this.getLog().info((CharSequence)("Transforming contents of folder " + input + " to " + outputDir));
                        HandleTransformation.transformDirectory(input.toFile(), outputDir, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite);
                        this.mavenProject.addTestCompileSourceRoot(outputDir.getAbsolutePath());
                    }
                    if (Files.exists(input = sourceProjectPath.resolve("src").resolve("main").resolve("resources"), new LinkOption[0]) && Files.isDirectory(input, new LinkOption[0])) {
                        outputDir = this.getOutputDirectory(LifecyclePhase.GENERATE_RESOURCES);
                        this.getLog().info((CharSequence)("Transforming contents of folder " + input + " to " + outputDir));
                        HandleTransformation.transformDirectory(input.toFile(), outputDir, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite);
                        Resource resource = new Resource();
                        resource.setDirectory(outputDir.getAbsolutePath());
                        this.mavenProject.addResource(resource);
                    }
                    if (Files.exists(input = sourceProjectPath.resolve("src").resolve("test").resolve("resources"), new LinkOption[0]) && Files.isDirectory(input, new LinkOption[0])) {
                        outputDir = this.getOutputDirectory(LifecyclePhase.GENERATE_TEST_RESOURCES);
                        this.getLog().info((CharSequence)("Transforming contents of folder " + input + " to " + outputDir));
                        HandleTransformation.transformDirectory(input.toFile(), outputDir, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite);
                        Resource testResource = new Resource();
                        testResource.setDirectory(outputDir.getAbsolutePath());
                        this.mavenProject.addTestResource(testResource);
                    }
                }
            }
            catch (IOException ioex) {
                throw new MojoExecutionException("Error transforming code", (Exception)ioex);
            }
        }
    }

    private LifecyclePhase valueOf(String phase) {
        if (LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(phase)) {
            return LifecyclePhase.GENERATE_TEST_SOURCES;
        }
        if (LifecyclePhase.GENERATE_RESOURCES.id().equals(phase)) {
            return LifecyclePhase.GENERATE_RESOURCES;
        }
        if (LifecyclePhase.GENERATE_TEST_RESOURCES.id().equals(phase)) {
            return LifecyclePhase.GENERATE_TEST_RESOURCES;
        }
        return LifecyclePhase.GENERATE_SOURCES;
    }

    private File getOutputDirectory(LifecyclePhase phase) throws IOException {
        Path outputDirectory = new File(this.mavenProject.getBuild().getDirectory()).toPath();
        if (this.outputFolder == null) {
            switch (phase) {
                case GENERATE_TEST_SOURCES: {
                    outputDirectory = outputDirectory.resolve("generated-test-sources").resolve("transformed");
                    break;
                }
                case GENERATE_RESOURCES: {
                    outputDirectory = outputDirectory.resolve("generated-resources").resolve("transformed");
                    break;
                }
                case GENERATE_TEST_RESOURCES: {
                    outputDirectory = outputDirectory.resolve("generated-test-resources").resolve("transformed");
                    break;
                }
                default: {
                    outputDirectory = outputDirectory.resolve("generated-sources").resolve("transformed");
                    break;
                }
            }
        } else {
            outputDirectory = new File(this.outputFolder).toPath();
        }
        if (!Files.exists(outputDirectory, new LinkOption[0])) {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        return outputDirectory.toFile();
    }
}

