/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.tool.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.wildfly.extras.transformer.tool.maven.HandleTransformation;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public class MavenPluginTransformer
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File projectRootFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.groupId}", required=true, readonly=true)
    private String groupId;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project.version}", required=true, readonly=true)
    private String version;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    private String packaging;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private String buildFolder;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String targetName;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private String outputFolder;
    @Parameter(defaultValue="${configs.dir}", readonly=true)
    private String configsDir;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private List<String> compileClasspathElements;
    @Parameter(property="inputFile")
    private File inputFile;
    @Parameter(property="outputFile")
    private File outputFile;

    public void execute() throws MojoExecutionException {
        File outputDirectory;
        this.dump();
        if (this.inputFile != null && this.outputFile != null) {
            try {
                System.out.println("transforming specific input " + this.inputFile.getAbsolutePath() + " into " + this.outputFile.getAbsolutePath());
                HandleTransformation.transformFile(this.inputFile, this.outputFile, this.configsDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.outputFolder != null && (outputDirectory = new File(this.outputFolder)).isDirectory()) {
            try {
                System.out.println("transforming contents of folder " + outputDirectory);
                HandleTransformation.transformDirectory(outputDirectory, this.configsDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        this.inputFile = null;
        if (this.mavenProject != null && this.mavenProject != null && this.mavenProject.getArtifact() != null && this.mavenProject.getArtifact().getFile() != null) {
            this.inputFile = this.mavenProject.getArtifact().getFile();
        } else if ((this.packaging.contains("jar") || this.packaging.contains("war") || this.packaging.contains("ear")) && this.buildFolder != null && this.targetName != null) {
            this.inputFile = new File(this.buildFolder + File.separatorChar + this.targetName + "." + this.packaging.toString());
        } else if (this.buildFolder != null && this.targetName != null) {
            this.inputFile = new File(this.buildFolder + File.separatorChar + this.targetName + ".jar");
        }
        if (this.inputFile != null && this.inputFile.exists()) {
            File outputDir = new File(this.inputFile.getParentFile(), this.inputFile.getName() + ".temp");
            File outputFile = new File(outputDir, this.inputFile.getName());
            System.out.println("transforming " + this.inputFile.getAbsolutePath() + " into " + outputFile.getAbsolutePath());
            try {
                HandleTransformation.transformFile(this.inputFile, outputFile, this.configsDir);
                if (outputDir.exists()) {
                    System.out.println("transformer generated output file " + outputFile.getAbsolutePath() + "  outputFile size = " + outputFile.length());
                    System.out.println("deleting " + this.inputFile.getName());
                    this.inputFile.delete();
                    System.out.println("rename " + outputFile.getAbsolutePath() + " to " + this.inputFile.getAbsolutePath());
                    outputFile.renameTo(this.inputFile);
                } else {
                    System.out.println("transformer didn't generate " + outputDir.getAbsolutePath());
                }
            }
            catch (IOException e) {
                System.out.println(" caught exception " + e.getMessage());
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private void dump() {
        System.out.println(((Object)((Object)this)).getClass().getName() + " dump of maven Mojo state stuff:");
        Map pluginContext = this.getPluginContext();
        for (Object key : pluginContext.keySet()) {
            System.out.println("plugin context key: " + key + " value: " + pluginContext.get(key));
        }
        System.out.println("projectRootFolder = " + this.projectRootFolder);
        System.out.println("mavenProject = " + this.mavenProject);
        System.out.println("groupId = " + this.groupId);
        System.out.println("artifactId = " + this.artifactId);
        System.out.println("version = " + this.version);
        System.out.println("packaging = " + this.packaging);
        System.out.println("outputFolder = " + this.outputFolder);
        System.out.println("buildFolder = " + this.buildFolder);
        System.out.println("compileClasspathElements = " + this.compileClasspathElements);
        System.out.println("inputJar =  " + this.inputFile);
        System.out.println("outputJar =  " + this.outputFile);
        System.out.println("targetName = " + this.targetName);
        System.out.println("configsDirectory = " + this.configsDir);
    }
}

