/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.tool.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.wildfly.extras.transformer.ArchiveTransformer;
import org.wildfly.extras.transformer.TransformerBuilder;
import org.wildfly.extras.transformer.TransformerFactory;

final class HandleTransformation {
    public static final String JAR_FILE_EXT = ".jar";

    HandleTransformation() {
    }

    static void transformDirectory(File folder, File targetFolder, String configsDir, boolean verbose, boolean overwrite) throws IOException {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File sourceFile : files) {
            File targetFile = new File(targetFolder, sourceFile.getName());
            if (sourceFile.isDirectory()) {
                HandleTransformation.transformDirectory(sourceFile, new File(targetFolder, sourceFile.getName()), configsDir, verbose, overwrite);
                continue;
            }
            if (targetFile.exists()) {
                if (!overwrite) continue;
                targetFile.delete();
                HandleTransformation.transformFile(sourceFile, new File(targetFolder, sourceFile.getName()), configsDir, verbose);
                continue;
            }
            HandleTransformation.transformFile(sourceFile, new File(targetFolder, sourceFile.getName()), configsDir, verbose);
        }
    }

    static void transformFile(File sourceFile, File targetFile, String configsDir, boolean verbose) throws IOException {
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("input file " + sourceFile.getName() + " does not exist");
        }
        TransformerBuilder builder = TransformerFactory.getInstance().newTransformer();
        if (configsDir != null) {
            builder.setConfigsDir(configsDir);
        }
        builder.setVerbose(verbose);
        ArchiveTransformer transformer = builder.build();
        if (!transformer.canTransformIndividualClassFile() && !sourceFile.getName().endsWith(JAR_FILE_EXT)) {
            throw new IllegalArgumentException("Supported file extensions are .jar : " + sourceFile.getAbsolutePath());
        }
        Files.createDirectories(targetFile.toPath().getParent(), new FileAttribute[0]);
        transformer.transform(sourceFile, targetFile);
    }
}

