/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer.tool.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.wildfly.extras.transformer.tool.maven.HandleTransformation;

@Mojo(name="transform-classes", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class MavenPluginTransformer
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    private String packaging;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private String buildFolder;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String targetName;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private String outputFolder;
    @Parameter(defaultValue="${configs.dir}", readonly=true)
    private String configsDir;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    private List<String> compileClasspathElements;
    @Parameter(property="inputFile")
    private File inputFile;
    @Parameter(property="outputFile")
    private File outputFile;
    @Parameter(property="overwrite", required=false, defaultValue="false")
    private boolean overwrite;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.dump();
        }
        if (this.inputFile != null && this.inputFile.isFile() && this.outputFile != null) {
            try {
                this.getLog().info((CharSequence)("transforming specific input " + this.inputFile.getAbsolutePath() + " into " + this.outputFile.getAbsolutePath()));
                HandleTransformation.transformFile(this.inputFile, this.outputFile, this.configsDir, this.getLog().isDebugEnabled());
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.inputFile != null && this.inputFile.isDirectory() && this.outputFolder != null) {
            File outputDirectory = new File(this.outputFolder);
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
            }
            if (outputDirectory.isDirectory()) {
                try {
                    this.getLog().info((CharSequence)("Transforming contents of folder " + this.inputFile + " to " + this.outputFolder));
                    HandleTransformation.transformDirectory(this.inputFile, outputDirectory, this.configsDir, this.getLog().isDebugEnabled(), this.overwrite);
                    return;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            }
        }
        this.inputFile = null;
        if (this.mavenProject != null && this.mavenProject != null && this.mavenProject.getArtifact() != null && this.mavenProject.getArtifact().getFile() != null) {
            this.inputFile = this.mavenProject.getArtifact().getFile();
        } else if ((this.packaging.contains("jar") || this.packaging.contains("war") || this.packaging.contains("ear")) && this.buildFolder != null && this.targetName != null) {
            this.inputFile = new File(this.buildFolder + File.separatorChar + this.targetName + "." + this.packaging);
        } else if (this.buildFolder != null && this.targetName != null) {
            this.inputFile = new File(this.buildFolder + File.separatorChar + this.targetName + ".jar");
        }
        if (this.inputFile != null && this.inputFile.exists()) {
            File outputDir = new File(this.inputFile.getParentFile(), this.inputFile.getName() + ".temp");
            File outputFile = new File(outputDir, this.inputFile.getName());
            this.getLog().info((CharSequence)("transforming " + this.inputFile.getAbsolutePath() + " into " + outputFile.getAbsolutePath()));
            try {
                HandleTransformation.transformFile(this.inputFile, outputFile, this.configsDir, this.getLog().isDebugEnabled());
                if (outputDir.exists()) {
                    this.getLog().info((CharSequence)("transformer generated output file " + outputFile.getAbsolutePath() + "  outputFile size = " + outputFile.length()));
                    this.getLog().info((CharSequence)("deleting " + this.inputFile.getName()));
                    this.inputFile.delete();
                    this.getLog().info((CharSequence)("rename " + outputFile.getAbsolutePath() + " to " + this.inputFile.getAbsolutePath()));
                    outputFile.renameTo(this.inputFile);
                } else {
                    this.getLog().info((CharSequence)("transformer didn't generate " + outputDir.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)(" caught exception " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private void dump() {
        this.getLog().debug((CharSequence)(((Object)((Object)this)).getClass().getName() + " dump of maven Mojo state stuff:"));
        Map pluginContext = this.getPluginContext();
        for (Object key : pluginContext.keySet()) {
            this.getLog().debug((CharSequence)("plugin context key: " + key + " value: " + pluginContext.get(key)));
        }
        this.getLog().debug((CharSequence)("mavenProject = " + this.mavenProject));
        this.getLog().debug((CharSequence)("packaging = " + this.packaging));
        this.getLog().debug((CharSequence)("outputFolder = " + this.outputFolder));
        this.getLog().debug((CharSequence)("buildFolder = " + this.buildFolder));
        this.getLog().debug((CharSequence)("compileClasspathElements = " + this.compileClasspathElements));
        this.getLog().debug((CharSequence)("inputJar =  " + this.inputFile));
        this.getLog().debug((CharSequence)("outputJar =  " + this.outputFile));
        this.getLog().debug((CharSequence)("targetName = " + this.targetName));
        this.getLog().debug((CharSequence)("configsDirectory = " + this.configsDir));
    }
}

