/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.datasources;

import org.wildfly.extras.creaper.commands.datasources.AddDataSource;
import org.wildfly.extras.creaper.core.ManagementVersion;

public final class AddMssqlDataSource
extends AddDataSource {
    AddMssqlDataSource(Builder builder) {
        super(builder);
    }

    @Override
    protected void modifyIfNeeded(ManagementVersion serverVersion) {
        if (this.backgroundValidation == null) {
            this.backgroundValidation = true;
        }
        if (this.backgroundValidationMillis == null) {
            this.backgroundValidationMillis = 60000;
        }
        if (this.validConnectionCheckerClass == null) {
            this.validConnectionCheckerClass = "org.jboss.jca.adapters.jdbc.extensions.mssql.MSSQLValidConnectionChecker";
        }
        if (this.exceptionSorterClass == null && serverVersion.greaterThanOrEqualTo(ManagementVersion.VERSION_1_7_0)) {
            this.exceptionSorterClass = "org.jboss.jca.adapters.jdbc.extensions.mssql.MSSQLExceptionSorter";
        }
    }

    public static final class Builder
    extends AddDataSource.Builder {
        public Builder(String name) {
            super(name);
        }

        @Override
        public AddMssqlDataSource build() {
            this.check();
            return new AddMssqlDataSource(this);
        }
    }
}

