/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.modules;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ManagementVersion;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public class AddModule
implements OnlineCommand {
    public static final String DEFAULT_SLOT = "main";
    private final char resourceDelimiter;
    private final String moduleName;
    private final String slot;
    private final String mainClass;
    private final String moduleXml;
    private final List<String> resources;
    private final List<String> dependencies;
    private final List<String> properties;

    private AddModule(Builder builder) {
        this.resourceDelimiter = builder.resourceDelimiter;
        this.moduleName = builder.moduleName;
        this.slot = builder.slot;
        this.mainClass = builder.mainClass;
        this.moduleXml = builder.moduleXml;
        this.resources = builder.resources;
        this.dependencies = builder.dependencies;
        this.properties = builder.properties;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.options.isDomain) {
            throw new CommandFailedException("AddModule command isn't supported in domain mode");
        }
        StringBuilder cmd = new StringBuilder("module add");
        cmd.append(" --name=").append(this.moduleName);
        cmd.append(" --slot=").append(this.slot);
        if (this.moduleXml != null) {
            cmd.append(" --module-xml=").append(this.moduleXml);
        }
        if (this.mainClass != null) {
            cmd.append(" --main-class=").append(this.mainClass);
        }
        Joiner resourcesJoiner = Joiner.on((char)File.pathSeparatorChar);
        if (ctx.serverVersion.greaterThanOrEqualTo(ManagementVersion.VERSION_2_0_0)) {
            cmd.append(" --resource-delimiter=").append(this.resourceDelimiter);
            resourcesJoiner = Joiner.on((char)this.resourceDelimiter);
        }
        if (!this.resources.isEmpty()) {
            cmd.append(" --resources=").append(resourcesJoiner.join(this.resources).replaceAll(" ", "\\\\ "));
        }
        Joiner defaultJoiner = Joiner.on((String)",");
        if (!this.dependencies.isEmpty()) {
            cmd.append(" --dependencies=").append(defaultJoiner.join(this.dependencies));
        }
        if (!this.properties.isEmpty()) {
            cmd.append(" --properties=").append(defaultJoiner.join(this.properties));
        }
        ctx.client.executeCli(cmd.toString());
    }

    public String toString() {
        return "AddModule " + this.moduleName;
    }

    public static final class Builder {
        private char resourceDelimiter = File.pathSeparatorChar;
        private final String moduleName;
        private final String slot;
        private String moduleXml;
        private String mainClass;
        private List<String> resources;
        private List<String> dependencies;
        private List<String> properties;

        public Builder(String moduleName) {
            this(moduleName, AddModule.DEFAULT_SLOT);
        }

        public Builder(String moduleName, String slot) {
            if (moduleName == null) {
                throw new IllegalArgumentException("moduleName cannot be null");
            }
            if (slot == null) {
                throw new IllegalArgumentException("slot cannot be null");
            }
            this.moduleName = moduleName;
            this.slot = slot;
            this.resources = new ArrayList<String>();
            this.dependencies = new ArrayList<String>();
            this.properties = new ArrayList<String>();
        }

        public Builder resource(File file) {
            if (file == null) {
                throw new IllegalArgumentException("resource file cannot be null");
            }
            this.resources.add(file.getAbsolutePath());
            return this;
        }

        public Builder resourceDelimiter(String delimiter) {
            if (delimiter == null) {
                throw new IllegalArgumentException("resource delimiter cannot be null");
            }
            if (delimiter.length() != 1) {
                throw new IllegalArgumentException("resource delimiter lenght was " + delimiter.length() + ", but only strings of length 1 are allowed");
            }
            char delimiterChar = delimiter.charAt(0);
            if (Character.isWhitespace(delimiterChar)) {
                throw new IllegalArgumentException("resource delimiter cannot be whitespace");
            }
            this.resourceDelimiter = delimiterChar;
            return this;
        }

        public Builder dependency(String dependency) {
            if (dependency == null) {
                throw new IllegalArgumentException("dependency name cannot be null");
            }
            this.dependencies.add(dependency);
            return this;
        }

        public Builder moduleXml(File moduleXml) {
            if (moduleXml == null) {
                throw new IllegalArgumentException("moduleXml file cannot be null");
            }
            this.moduleXml = moduleXml.getAbsolutePath();
            return this;
        }

        public Builder property(String name, String value) {
            if (name == null) {
                throw new NullPointerException("property name cannot be null");
            }
            if (value == null) {
                throw new NullPointerException("property value cannot be null");
            }
            this.properties.add(name + "=" + value);
            return this;
        }

        public Builder mainClass(String mainClass) {
            if (mainClass == null) {
                throw new NullPointerException("mainClass cannot be null");
            }
            this.mainClass = mainClass;
            return this;
        }

        public AddModule build() {
            return new AddModule(this);
        }
    }
}

