/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.logging.AbstractConsoleLogHandlerCommand;
import org.wildfly.extras.creaper.commands.logging.ConsoleTarget;
import org.wildfly.extras.creaper.core.ManagementVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class ChangeConsoleLogHandler
extends AbstractConsoleLogHandlerCommand {
    private ChangeConsoleLogHandler(Builder builder) {
        super(builder);
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Address handlerAddress;
        Operations ops;
        if (ConsoleTarget.CONSOLE == this.target) {
            ctx.client.serverVersion().assertAtLeast(ManagementVersion.VERSION_3_0_0, "ConsoleTarget.CONSOLE is only available since WildFly 9");
        }
        if (!(ops = new Operations(ctx.client)).exists(handlerAddress = Address.subsystem((String)"logging").and("console-handler", this.name))) {
            throw new IllegalStateException(String.format("console handler %s does not exist.", this.name));
        }
        Batch batch = new Batch();
        if (this.autoflush != null) {
            batch.writeAttribute(handlerAddress, "autoflush", this.autoflush.booleanValue());
        }
        if (this.enabled != null) {
            batch.writeAttribute(handlerAddress, "enabled", this.enabled.booleanValue());
        }
        if (this.filter != null) {
            ops.writeAttribute(handlerAddress, "filter-spec", this.filter);
        }
        if (this.encoding != null) {
            batch.writeAttribute(handlerAddress, "encoding", this.encoding);
        }
        if (this.target != null) {
            batch.writeAttribute(handlerAddress, "target", this.target.value());
        }
        if (this.patternFormatter != null) {
            batch.writeAttribute(handlerAddress, "formatter", this.patternFormatter);
        }
        if (this.namedFormatter != null) {
            batch.writeAttribute(handlerAddress, "named-formatter", this.namedFormatter);
        }
        if (this.level != null) {
            batch.writeAttribute(handlerAddress, "level", this.level.value());
        }
        ops.batch(batch);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(ChangeConsoleLogHandler.class).subtree("logging", Subtree.subsystem("logging")).parameter("name", this.name).parameter("autoflush", this.autoflush == null ? null : String.valueOf(this.autoflush)).parameter("enabled", this.enabled == null ? null : String.valueOf(this.enabled)).parameter("filter", this.filter).parameter("encoding", this.encoding == null ? null : this.encoding).parameter("target", this.target == null ? null : this.target.value()).parameter("patternFormatter", this.patternFormatter).parameter("namedFormatter", this.namedFormatter).parameter("level", this.level == null ? null : this.level.value()).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "ChangeConsoleLogHandler " + this.name;
    }

    public static final class Builder
    extends AbstractConsoleLogHandlerCommand.Builder<Builder> {
        public Builder(String name) {
            super(name);
        }

        @Override
        public ChangeConsoleLogHandler build() {
            this.validate();
            return new ChangeConsoleLogHandler(this);
        }
    }
}

