/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.datasources;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.extras.creaper.commands.datasources.PoolFlushStrategy;
import org.wildfly.extras.creaper.commands.datasources.TrackStatementType;
import org.wildfly.extras.creaper.commands.datasources.TransactionIsolation;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ManagementVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class AddDataSource
implements OnlineCommand,
OfflineCommand {
    private final String name;
    private final String connectionUrl;
    private final String jndiName;
    private final boolean enableAfterCreation;
    private final boolean replaceExisting;
    protected Integer allocationRetry;
    protected Integer allocationRetryWaitMillis;
    protected Boolean allowMultipleUsers;
    protected Boolean backgroundValidation;
    protected Integer backgroundValidationMillis;
    protected Integer blockingTimeoutMillis;
    protected String checkValidConnectionSql;
    protected Boolean connectable;
    protected Map<String, String> connectionProperties;
    protected String datasourceClass;
    protected String driverClass;
    protected String driverName;
    protected String exceptionSorterClass;
    protected Map<String, String> exceptionSorterProperties;
    protected Integer idleTimeoutMinutes;
    protected Boolean jta;
    protected String managedConnectionPool;
    protected Integer maxPoolSize;
    protected Integer minPoolSize;
    protected String newConnectionSql;
    protected String password;
    protected PoolFlushStrategy flushStrategy;
    protected Boolean prefill;
    protected Integer preparedStatementCacheSize;
    protected Integer queryTimeout;
    protected String reauthPluginClass;
    protected Map<String, String> reauthPluginProperties;
    protected String securityDomain;
    protected Boolean setTxQueryTimeout;
    protected Boolean sharePreparedStatements;
    protected Boolean spy;
    protected String staleConnectionCheckerClass;
    protected Map<String, String> staleConnectionCheckerProperties;
    protected Boolean statisticsEnabled;
    protected TrackStatementType trackStatements;
    protected TransactionIsolation transactionIsolation;
    protected String urlDelimiter;
    protected String urlSelectorStrategyClass;
    protected Boolean useCcm;
    protected Boolean useFastFailAllocation;
    protected Boolean useJavaContext;
    protected Boolean useStrictMinPoolSize;
    protected Integer useTryLock;
    protected String username;
    protected Boolean validateOnMatch;
    protected String validConnectionCheckerClass;
    protected Map<String, String> validConnectionCheckerProperties;

    protected AddDataSource(Builder builder) {
        this.name = builder.name;
        this.connectionUrl = builder.connectionUrl;
        this.jndiName = builder.jndiName;
        this.enableAfterCreation = builder.enableAfterCreation;
        this.replaceExisting = builder.replaceExisting;
        this.driverClass = builder.driverClass;
        this.datasourceClass = builder.datasourceClass;
        this.connectionProperties = builder.connectionProperties;
        this.driverName = builder.driverName;
        this.username = builder.username;
        this.password = builder.password;
        this.securityDomain = builder.securityDomain;
        this.reauthPluginClass = builder.reauthPluginClass;
        this.reauthPluginProperties = builder.reauthPluginProperties;
        this.jta = builder.jta;
        this.useJavaContext = builder.useJavaContext;
        this.connectable = builder.connectable;
        this.managedConnectionPool = builder.managedConnectionPool;
        this.maxPoolSize = builder.maxPoolSize;
        this.minPoolSize = builder.minPoolSize;
        this.statisticsEnabled = builder.statisticsEnabled;
        this.useCcm = builder.useCcm;
        this.prefill = builder.prefill;
        this.useStrictMinPoolSize = builder.useStrictMinPoolSize;
        this.flushStrategy = builder.flushStrategy;
        this.allowMultipleUsers = builder.allowMultipleUsers;
        this.newConnectionSql = builder.newConnectionSql;
        this.transactionIsolation = builder.transactionIsolation;
        this.urlDelimiter = builder.urlDelimiter;
        this.urlSelectorStrategyClass = builder.urlSelectorStrategyClass;
        this.checkValidConnectionSql = builder.checkValidConnectionSql;
        this.validateOnMatch = builder.validateOnMatch;
        this.backgroundValidation = builder.backgroundValidation;
        this.backgroundValidationMillis = builder.backgroundValidationMillis;
        this.useFastFailAllocation = builder.useFastFailAllocation;
        this.staleConnectionCheckerClass = builder.staleConnectionCheckerClass;
        this.staleConnectionCheckerProperties = builder.staleConnectionCheckerProperties;
        this.exceptionSorterClass = builder.exceptionSorterClass;
        this.exceptionSorterProperties = builder.exceptionSorterProperties;
        this.spy = builder.spy;
        this.blockingTimeoutMillis = builder.blockingTimeoutWaitMillis;
        this.idleTimeoutMinutes = builder.idleTimeoutMinutes;
        this.setTxQueryTimeout = builder.setTxQueryTimeout;
        this.queryTimeout = builder.queryTimeout;
        this.useTryLock = builder.useTryLock;
        this.allocationRetry = builder.allocationRetry;
        this.allocationRetryWaitMillis = builder.allocationRetryWaitMillis;
        this.validConnectionCheckerClass = builder.validConnectionCheckerClass;
        this.validConnectionCheckerProperties = builder.validConnectionCheckerProperties;
        this.preparedStatementCacheSize = builder.preparedStatementsCacheSize;
        this.trackStatements = builder.trackPreparedStatements;
        this.sharePreparedStatements = builder.sharePreparedStatements;
    }

    public final void apply(OnlineCommandContext ctx) throws IOException, CommandFailedException {
        this.modifyIfNeeded(ctx.serverVersion);
        Operations ops = new Operations(ctx.client);
        Address dsAddress = Address.subsystem((String)"datasources").and("data-source", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(dsAddress);
                new Administration(ctx.client).reloadIfRequired();
            }
            catch (Exception e) {
                throw new CommandFailedException("Failed to remove existing datasource " + this.name, (Throwable)e);
            }
        }
        Values values = Values.empty().andOptional("connection-url", this.connectionUrl).andOptional("jndi-name", this.jndiName).andOptional("driver-name", this.driverName).andOptional("user-name", this.username).andOptional("password", this.password).andOptional("jta", this.jta).andOptional("use-java-context", this.useJavaContext).andOptional("connectable", this.connectable).andOptional("mcp", this.managedConnectionPool).andOptional("max-pool-size", this.maxPoolSize).andOptional("min-pool-size", this.minPoolSize).andOptional("statistics-enabled", this.statisticsEnabled).andOptional("driver-class", this.driverClass).andOptional("datasource-class", this.datasourceClass).andOptional("pool-use-strict-min", this.useStrictMinPoolSize).andOptional("allow-multiple-users", this.allowMultipleUsers).andOptional("pool-prefill", this.prefill).andOptional("new-connection-sql", this.newConnectionSql).andOptional("url-delimiter", this.urlDelimiter).andOptional("url-selector-strategy-class-name", this.urlSelectorStrategyClass).andOptional("check-valid-connection-sql", this.checkValidConnectionSql).andOptional("validate-on-match", this.validateOnMatch).andOptional("background-validation", this.backgroundValidation).andOptional("background-validation-millis", this.backgroundValidationMillis).andOptional("use-fast-fail", this.useFastFailAllocation).andOptional("stale-connection-checker-class-name", this.staleConnectionCheckerClass).andObjectOptional("stale-connection-checker-properties", Values.fromMap(this.staleConnectionCheckerProperties)).andOptional("exception-sorter-class-name", this.exceptionSorterClass).andObjectOptional("exception-sorter-properties", Values.fromMap(this.exceptionSorterProperties)).andOptional("valid-connection-checker-class-name", this.validConnectionCheckerClass).andObjectOptional("valid-connection-checker-properties", Values.fromMap(this.validConnectionCheckerProperties)).andOptional("spy", this.spy).andOptional("blocking-timeout-wait-millis", this.blockingTimeoutMillis).andOptional("idle-timeout-minutes", this.idleTimeoutMinutes).andOptional("set-tx-query-timeout", this.setTxQueryTimeout).andOptional("query-timeout", this.queryTimeout).andOptional("use-try-lock", this.useTryLock).andOptional("allocation-retry", this.allocationRetry).andOptional("allocation-retry-wait-millis", this.allocationRetryWaitMillis).andOptional("security-domain", this.securityDomain).andOptional("reauth-plugin-class-name", this.reauthPluginClass).andObjectOptional("reauth-plugin-properties", Values.fromMap(this.reauthPluginProperties)).andOptional("use-ccm", this.useCcm).andOptional("prepared-statements-cache-size", this.preparedStatementCacheSize).andOptional("share-prepared-statements", this.sharePreparedStatements).and("enabled", this.enableAfterCreation);
        if (this.flushStrategy != null) {
            values = values.and("flush-strategy", this.flushStrategy.value());
        }
        if (this.transactionIsolation != null) {
            values = values.and("transaction-isolation", this.transactionIsolation.value());
        }
        if (this.trackStatements != null) {
            values = values.and("track-statements", this.trackStatements.value());
        }
        Batch batch = new Batch();
        batch.add(dsAddress, values);
        if (this.connectionProperties != null) {
            for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
                batch.add(dsAddress.and("connection-properties", entry.getKey()), Values.of((String)"value", (String)entry.getValue()));
            }
        }
        if (this.enableAfterCreation && ctx.serverVersion.lessThan(ManagementVersion.VERSION_2_0_0)) {
            batch.invoke("enable", dsAddress);
        }
        ops.batch(batch);
    }

    public final void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        this.modifyIfNeeded(ctx.serverVersion);
        GroovyXmlTransform transform = GroovyXmlTransform.of(AddDataSource.class).subtree("datasources", Subtree.subsystem("datasources")).parameter("poolName", this.name).parameter("connectioUrl", this.connectionUrl).parameter("jndiName", this.jndiName).parameter("driverName", this.driverName).parameter("userName", this.username).parameter("password", this.password).parameter("jta", this.jta).parameter("useJavaContext", this.useJavaContext).parameter("connectable", this.connectable).parameter("maxPoolSize", this.maxPoolSize).parameter("minPoolSize", this.minPoolSize).parameter("statisticsEnabled", this.statisticsEnabled).parameter("driverClass", this.driverClass).parameter("datasourceClass", this.datasourceClass).parameter("useStrictMinPoolSize", this.useStrictMinPoolSize).parameter("flushStrategy", this.flushStrategy == null ? null : this.flushStrategy.value()).parameter("allowMultipleUsers", this.allowMultipleUsers).parameter("mcp", this.managedConnectionPool).parameter("prefill", this.prefill).parameter("newConnectionSql", this.newConnectionSql).parameter("transactionIsolation", this.transactionIsolation == null ? null : this.transactionIsolation.value()).parameter("urlDelimiter", this.urlDelimiter).parameter("urlSelectorStrategyClassName", this.urlSelectorStrategyClass).parameter("checkValidConnectionSql", this.checkValidConnectionSql).parameter("validateOnMatch", this.validateOnMatch).parameter("backgroundValidation", this.backgroundValidation).parameter("backgroundValidationMillis", this.backgroundValidationMillis).parameter("useFastFail", this.useFastFailAllocation).parameter("staleConnectionCheckerClassName", this.staleConnectionCheckerClass).parameter("staleConnectionCheckerProperties", this.staleConnectionCheckerProperties).parameter("exceptionSorterClassName", this.exceptionSorterClass).parameter("exceptionSorterProperties", this.exceptionSorterProperties).parameter("validConnectionCheckerClassName", this.validConnectionCheckerClass).parameter("validConnectionCheckerProperties", this.validConnectionCheckerProperties).parameter("spy", this.spy).parameter("blockingTimeoutWaitMillis", this.blockingTimeoutMillis).parameter("idleTimeoutMinutes", this.idleTimeoutMinutes).parameter("setTxQueryTimeout", this.setTxQueryTimeout).parameter("queryTimeout", this.queryTimeout).parameter("useTryLock", this.useTryLock).parameter("allocationRetry", this.allocationRetry).parameter("allocationRetryWaitMillis", this.allocationRetryWaitMillis).parameter("securityDomain", this.securityDomain).parameter("reauthPluginClassName", this.reauthPluginClass).parameter("reauthPluginProperties", this.reauthPluginProperties).parameter("useCcm", this.useCcm).parameter("preparedStatementsCacheSize", this.preparedStatementCacheSize).parameter("trackStatements", this.trackStatements == null ? null : this.trackStatements.value()).parameter("sharePreparedStatements", this.sharePreparedStatements).parameter("connectionProperties", this.connectionProperties).parameter("enableAfterCreation", this.enableAfterCreation).parameter("replaceExisting", this.replaceExisting).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    protected void modifyIfNeeded(ManagementVersion serverVersion) {
    }

    public final String toString() {
        return "AddDataSource " + this.name;
    }

    public static class Builder<THIS extends Builder> {
        private String name;
        private boolean enableAfterCreation = false;
        private boolean replaceExisting = false;
        private Integer allocationRetry;
        private Integer allocationRetryWaitMillis;
        private Boolean allowMultipleUsers;
        private Boolean backgroundValidation;
        private Integer backgroundValidationMillis;
        private Integer blockingTimeoutWaitMillis;
        private String checkValidConnectionSql;
        private Boolean connectable;
        private Map<String, String> connectionProperties = new HashMap<String, String>();
        private String connectionUrl;
        private String datasourceClass;
        private String driverClass;
        private String driverName;
        private String exceptionSorterClass;
        private Map<String, String> exceptionSorterProperties = new HashMap<String, String>();
        private Integer idleTimeoutMinutes;
        private String jndiName;
        private Boolean jta;
        private String managedConnectionPool;
        private Integer maxPoolSize;
        private Integer minPoolSize;
        private String newConnectionSql;
        private String password;
        private PoolFlushStrategy flushStrategy;
        private Boolean prefill;
        private Integer preparedStatementsCacheSize;
        private Integer queryTimeout;
        private String reauthPluginClass;
        private Map<String, String> reauthPluginProperties = new HashMap<String, String>();
        private String securityDomain;
        private Boolean setTxQueryTimeout;
        private Boolean sharePreparedStatements;
        private Boolean spy;
        private String staleConnectionCheckerClass;
        private Map<String, String> staleConnectionCheckerProperties = new HashMap<String, String>();
        private Boolean statisticsEnabled;
        private TrackStatementType trackPreparedStatements;
        private TransactionIsolation transactionIsolation;
        private String urlDelimiter;
        private String urlSelectorStrategyClass;
        private Boolean useCcm;
        private Boolean useFastFailAllocation;
        private Boolean useJavaContext;
        private Boolean useStrictMinPoolSize;
        private Integer useTryLock;
        private String username;
        private Boolean validateOnMatch;
        private String validConnectionCheckerClass;
        private Map<String, String> validConnectionCheckerProperties = new HashMap<String, String>();

        public Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of the data-source must be specified as non null value");
            }
            this.name = name;
        }

        public final THIS connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            return (THIS)this;
        }

        public final THIS driverName(String driverName) {
            this.driverName = driverName;
            return (THIS)this;
        }

        public final THIS jndiName(String jndiName) {
            this.jndiName = jndiName;
            return (THIS)this;
        }

        public final THIS driverClass(String driverClass) {
            this.driverClass = driverClass;
            return (THIS)this;
        }

        public final THIS datasourceClass(String datasourceClass) {
            this.datasourceClass = datasourceClass;
            return (THIS)this;
        }

        public final THIS addConnectionProperty(String name, String value) {
            this.connectionProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addConnectionProperty(String name, boolean value) {
            this.connectionProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS addConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties.putAll(connectionProperties);
            return (THIS)this;
        }

        public final THIS usernameAndPassword(String username, String password) {
            this.username = username;
            this.password = password;
            return (THIS)this;
        }

        public final THIS enableAfterCreate() {
            this.enableAfterCreation = true;
            return (THIS)this;
        }

        public final THIS replaceExisting() {
            this.replaceExisting = true;
            return (THIS)this;
        }

        public final THIS jta(Boolean jta) {
            this.jta = jta;
            return (THIS)this;
        }

        public final THIS useJavaContext(Boolean useJavaContext) {
            this.useJavaContext = useJavaContext;
            return (THIS)this;
        }

        public final THIS connectable(Boolean connectable) {
            this.connectable = connectable;
            return (THIS)this;
        }

        public final THIS maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return (THIS)this;
        }

        public final THIS minPoolSize(int minPoolSize) {
            this.minPoolSize = minPoolSize;
            return (THIS)this;
        }

        public final THIS statisticsEnabled(Boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
            return (THIS)this;
        }

        public final THIS useCcm(Boolean useCcm) {
            this.useCcm = useCcm;
            return (THIS)this;
        }

        public final THIS newConnectionSql(String newConnectionSql) {
            this.newConnectionSql = newConnectionSql;
            return (THIS)this;
        }

        public final THIS transactionIsolation(TransactionIsolation transactionIsolation) {
            this.transactionIsolation = transactionIsolation;
            return (THIS)this;
        }

        public final THIS urlDelimiter(String urlDelimiter) {
            this.urlDelimiter = urlDelimiter;
            return (THIS)this;
        }

        public final THIS urlSelectorStrategyClass(String urlSelectorStrategyClass) {
            this.urlSelectorStrategyClass = urlSelectorStrategyClass;
            return (THIS)this;
        }

        public final THIS prefill(Boolean prefill) {
            this.prefill = prefill;
            return (THIS)this;
        }

        public final THIS securityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return (THIS)this;
        }

        public final THIS reauthPluginClass(String reauthPluginClass) {
            this.reauthPluginClass = reauthPluginClass;
            return (THIS)this;
        }

        public final THIS addReauthPluginProperty(String name, String value) {
            this.reauthPluginProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addReauthPluginProperty(String name, boolean value) {
            this.reauthPluginProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS useStrictMinPoolSize(Boolean useStrictMinPoolSize) {
            this.useStrictMinPoolSize = useStrictMinPoolSize;
            return (THIS)this;
        }

        public final THIS flushStrategy(PoolFlushStrategy flushStrategy) {
            this.flushStrategy = flushStrategy;
            return (THIS)this;
        }

        public final THIS checkValidConnectionSql(String checkValidConnectionSql) {
            this.checkValidConnectionSql = checkValidConnectionSql;
            return (THIS)this;
        }

        public final THIS validateOnMatch(Boolean validateOnMatch) {
            this.validateOnMatch = validateOnMatch;
            return (THIS)this;
        }

        public final THIS backgroundValidation(Boolean backgroundValidation) {
            this.backgroundValidation = backgroundValidation;
            return (THIS)this;
        }

        public final THIS backgroundValidationMillis(Integer backgroundValidationMillis) {
            this.backgroundValidationMillis = backgroundValidationMillis;
            return (THIS)this;
        }

        public final THIS useFastFailAllocation(Boolean useFastFailAllocation) {
            this.useFastFailAllocation = useFastFailAllocation;
            return (THIS)this;
        }

        public final THIS staleConnectionCheckerClass(String staleConnectionCheckerClass) {
            this.staleConnectionCheckerClass = staleConnectionCheckerClass;
            return (THIS)this;
        }

        public final THIS addStaleConnectionCheckerProperty(String name, String value) {
            this.staleConnectionCheckerProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addStaleConnectionCheckerProperty(String name, boolean value) {
            this.staleConnectionCheckerProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS validConnectionCheckerClass(String validConnectionCheckerClass) {
            this.validConnectionCheckerClass = validConnectionCheckerClass;
            return (THIS)this;
        }

        public final THIS addValidConnectionCheckerProperty(String name, String value) {
            this.validConnectionCheckerProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addValidConnectionCheckerProperty(String name, boolean value) {
            this.validConnectionCheckerProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS exceptionSorterClass(String exceptionSorterClass) {
            this.exceptionSorterClass = exceptionSorterClass;
            return (THIS)this;
        }

        public final THIS addExceptionSorterProperty(String name, String value) {
            this.exceptionSorterProperties.put(name, value);
            return (THIS)this;
        }

        public final THIS addExceptionSorterProperty(String name, boolean value) {
            this.exceptionSorterProperties.put(name, Boolean.toString(value));
            return (THIS)this;
        }

        public final THIS spy(Boolean spy) {
            this.spy = spy;
            return (THIS)this;
        }

        public final THIS blockingTimeoutWaitMillis(Integer blockingTimeoutWaitMillis) {
            this.blockingTimeoutWaitMillis = blockingTimeoutWaitMillis;
            return (THIS)this;
        }

        public final THIS idleTimeoutMinutes(Integer idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
            return (THIS)this;
        }

        public final THIS setTxQueryTimeout(Boolean setTxQueryTimeout) {
            this.setTxQueryTimeout = setTxQueryTimeout;
            return (THIS)this;
        }

        public final THIS allowMultipleUsers(Boolean allowMultipleUsers) {
            this.allowMultipleUsers = allowMultipleUsers;
            return (THIS)this;
        }

        public final THIS queryTimeout(Integer queryTimeout) {
            this.queryTimeout = queryTimeout;
            return (THIS)this;
        }

        public final THIS useTryLock(Integer useTryLock) {
            this.useTryLock = useTryLock;
            return (THIS)this;
        }

        public final THIS allocationRetry(Integer allocationRetry) {
            this.allocationRetry = allocationRetry;
            return (THIS)this;
        }

        public final THIS allocationRetryWaitMillis(Integer allocationRetryWaitMillis) {
            this.allocationRetryWaitMillis = allocationRetryWaitMillis;
            return (THIS)this;
        }

        public final THIS trackPreparedStatements(TrackStatementType trackStatements) {
            this.trackPreparedStatements = trackStatements;
            return (THIS)this;
        }

        public final THIS sharePreparedStatements(Boolean sharePreparedStatements) {
            this.sharePreparedStatements = sharePreparedStatements;
            return (THIS)this;
        }

        public final THIS preparedStatementsCacheSize(Integer preparedStatementsCacheSize) {
            this.preparedStatementsCacheSize = preparedStatementsCacheSize;
            return (THIS)this;
        }

        public final THIS managedConnectionPool(String managedConnectionPool) {
            this.managedConnectionPool = managedConnectionPool;
            return (THIS)this;
        }

        public AddDataSource build() {
            this.check();
            return new AddDataSource(this);
        }

        protected final void check() {
            if (this.connectionUrl == null) {
                throw new IllegalArgumentException("URL of the connection must be specified as non null value");
            }
            if (this.jndiName == null) {
                throw new IllegalArgumentException("jndiName must be specified as non null value");
            }
            if (this.driverName == null) {
                throw new IllegalArgumentException("driverName must be specified as non null value");
            }
            if (this.minPoolSize != null && this.minPoolSize < 0) {
                throw new IllegalArgumentException("minPoolSize must be greater than 0 but it's set to " + this.minPoolSize);
            }
            if (this.maxPoolSize != null && this.maxPoolSize < 0) {
                throw new IllegalArgumentException("maxPoolSize must be greater than 0 but it's set to " + this.maxPoolSize);
            }
            if (this.maxPoolSize != null && this.minPoolSize != null && this.minPoolSize > this.maxPoolSize) {
                throw new IllegalArgumentException("maxPoolSize has to be greater than minPoolSize but they are set to " + this.minPoolSize + " and " + this.maxPoolSize);
            }
            if (this.backgroundValidationMillis != null && this.backgroundValidationMillis < 0) {
                throw new IllegalArgumentException("backgroundValidationMilis has to be greater than 0 but it's set to " + this.backgroundValidationMillis);
            }
            if (this.queryTimeout != null && this.queryTimeout < 0) {
                throw new IllegalArgumentException("queryTimeout has to be greater than 0 but it's set to " + this.queryTimeout);
            }
            if (this.useTryLock != null && this.useTryLock < 0) {
                throw new IllegalArgumentException("useTryLock has to be greater than 0 but it's set to " + this.useTryLock);
            }
            if (this.allocationRetry != null && this.allocationRetry < 0) {
                throw new IllegalArgumentException("allocationRetry has to be greater than 0 but it's set to " + this.allocationRetry);
            }
            if (this.allocationRetryWaitMillis != null && this.allocationRetryWaitMillis < 0) {
                throw new IllegalArgumentException("allocationRetryWaitMillis has to be greater than 0 but it's set to " + this.allocationRetryWaitMillis);
            }
            if (this.preparedStatementsCacheSize != null && this.preparedStatementsCacheSize < 0) {
                throw new IllegalArgumentException("preparedStatementCacheSize has to be greater than 0 but it's set to " + this.preparedStatementsCacheSize);
            }
            if (this.securityDomain != null && this.username != null) {
                throw new IllegalArgumentException("Setting username is invalid in combination with securityDomain");
            }
        }
    }
}

