/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.logging.AbstractConsoleLogHandlerCommand;
import org.wildfly.extras.creaper.commands.logging.ConsoleTarget;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ManagementVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddConsoleLogHandler
extends AbstractConsoleLogHandlerCommand {
    private final boolean replaceExisting;

    private AddConsoleLogHandler(Builder builder) {
        super(builder);
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ConsoleTarget.CONSOLE == this.target) {
            ctx.client.serverVersion().assertAtLeast(ManagementVersion.VERSION_3_0_0, "ConsoleTarget.CONSOLE is only available since WildFly 9");
        }
        Operations ops = new Operations(ctx.client);
        Address handlerAddress = Address.subsystem((String)"logging").and("console-handler", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(handlerAddress);
            }
            catch (OperationException e) {
                throw new CommandFailedException("Failed to remove existing console-handler " + this.name, (Throwable)e);
            }
        }
        ops.add(handlerAddress, Values.empty().andOptional("autoflush", this.autoflush).andOptional("enabled", this.enabled).andOptional("level", this.level == null ? null : this.level.value()).andOptional("filter-spec", this.filter).andOptional("encoding", this.encoding).andOptional("target", this.target == null ? null : this.target.value()).andOptional("named-formatter", this.namedFormatter).andOptional("formatter", this.patternFormatter));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(AddConsoleLogHandler.class).subtree("logging", Subtree.subsystem("logging")).parameter("name", this.name).parameter("autoflush", this.autoflush == null ? null : String.valueOf(this.autoflush)).parameter("enabled", this.enabled == null ? null : String.valueOf(this.enabled)).parameter("filter", this.filter).parameter("encoding", this.encoding).parameter("target", this.target == null ? null : this.target.value()).parameter("patternFormatter", this.patternFormatter).parameter("namedFormatter", this.namedFormatter).parameter("level", this.level == null ? null : this.level.value()).parameter("replaceExisting", this.replaceExisting).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "AddConsoleLogHandler " + this.name;
    }

    public static final class Builder
    extends AbstractConsoleLogHandlerCommand.Builder<Builder> {
        private boolean replaceExisting;

        public Builder(String name) {
            super(name);
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        @Override
        public AddConsoleLogHandler build() {
            this.validate();
            return new AddConsoleLogHandler(this);
        }
    }
}

