/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.logging.LogHandlerType;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveLogHandler
implements OnlineCommand,
OfflineCommand {
    private final LogHandlerType type;
    private final String name;

    public RemoveLogHandler(LogHandlerType type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("Handler type can not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Handler name can not be null.");
        }
        this.type = type;
        this.name = name;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        ops.removeIfExists(Address.subsystem((String)"logging").and(this.type.value(), this.name));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(RemoveLogHandler.class).subtree("logging", Subtree.subsystem("logging")).parameter("name", this.name).parameter("type", this.type.value()).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "RemoveLogHandler " + this.name;
    }
}

