/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.messaging;

import java.io.IOException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.messaging.MessagingUtils;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveQueue
implements OnlineCommand,
OfflineCommand {
    private final String queueName;
    private final String serverName;

    public RemoveQueue(String queueName) {
        this(queueName, "default");
    }

    public RemoveQueue(String queueName, String serverName) {
        if (queueName == null) {
            throw new IllegalArgumentException("Name of the queue must be specified as non null value");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Server name must be specified as non null value");
        }
        this.queueName = queueName;
        this.serverName = serverName;
    }

    public void apply(OnlineCommandContext ctx) throws IOException, CommandFailedException {
        Operations ops = new Operations(ctx.client);
        ops.remove(MessagingUtils.address(ctx.client, this.serverName).and("jms-queue", this.queueName));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException {
        if (!"default".equals(this.serverName)) {
            throw new CommandFailedException("Non-default messaging server name not yet implemented in offline mode");
        }
        GroovyXmlTransform transform = GroovyXmlTransform.of(RemoveQueue.class).subtree("messagingHornetq", Subtree.subsystem("messaging")).subtree("messagingActivemq", Subtree.subsystem("messaging-activemq")).parameter("queueName", this.queueName).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "RemoveQueue " + this.queueName;
    }
}

