/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.modules;

import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public final class RemoveModule
implements OnlineCommand {
    private final String moduleName;
    private final String slot;

    public RemoveModule(String moduleName) {
        this(moduleName, "main");
    }

    public RemoveModule(String moduleName, String slot) {
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName cannot be null");
        }
        if (slot == null) {
            throw new IllegalArgumentException("slot cannot be null");
        }
        this.moduleName = moduleName;
        this.slot = slot;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.options.isDomain) {
            throw new CommandFailedException("RemoveModule command isn't supported in domain mode");
        }
        ctx.client.executeCli("module remove --name=" + this.moduleName + " --slot=" + this.slot);
    }

    public String toString() {
        return "RemoveModule " + this.moduleName;
    }
}

