/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.wildfly.extras.creaper.commands.logging.AddConsoleLogHandler;
import org.wildfly.extras.creaper.commands.logging.AddLogger;
import org.wildfly.extras.creaper.commands.logging.AddPeriodicRotatingFileLogHandler;
import org.wildfly.extras.creaper.commands.logging.ChangeConsoleLogHandler;
import org.wildfly.extras.creaper.commands.logging.ChangeLogger;
import org.wildfly.extras.creaper.commands.logging.ChangePeriodicRotatingFileLogHandler;
import org.wildfly.extras.creaper.commands.logging.ChangeRootLogger;
import org.wildfly.extras.creaper.commands.logging.LogHandlerType;
import org.wildfly.extras.creaper.commands.logging.RemoveLogHandler;
import org.wildfly.extras.creaper.commands.logging.RemoveLogger;

public final class Logging {
    private Logging() {
    }

    public static RootLogger rootLogger() {
        return RootLogger.INSTANCE;
    }

    public static Logger logger() {
        return Logger.INSTANCE;
    }

    public static LogHandler handler() {
        return LogHandler.INSTANCE;
    }

    public static final class PeriodicRotatingFileLogHandler {
        private static final PeriodicRotatingFileLogHandler INSTANCE = new PeriodicRotatingFileLogHandler();

        private PeriodicRotatingFileLogHandler() {
        }

        public AddPeriodicRotatingFileLogHandler.Builder add(String name, String file, String suffix) {
            return new AddPeriodicRotatingFileLogHandler.Builder(name, file, suffix);
        }

        public ChangePeriodicRotatingFileLogHandler.Builder change(String name) {
            return new ChangePeriodicRotatingFileLogHandler.Builder(name, null, null);
        }

        public ChangePeriodicRotatingFileLogHandler.Builder change(String name, String file, String suffix) {
            return new ChangePeriodicRotatingFileLogHandler.Builder(name, file, suffix);
        }

        public RemoveLogHandler remove(String name) {
            return new RemoveLogHandler(LogHandlerType.PERIODIC_ROTATING_FILE, name);
        }
    }

    public static final class ConsoleLogHandler {
        private static final ConsoleLogHandler INSTANCE = new ConsoleLogHandler();

        private ConsoleLogHandler() {
        }

        public AddConsoleLogHandler.Builder add(String name) {
            return new AddConsoleLogHandler.Builder(name);
        }

        public ChangeConsoleLogHandler.Builder change(String name) {
            return new ChangeConsoleLogHandler.Builder(name);
        }

        public RemoveLogHandler remove(String name) {
            return new RemoveLogHandler(LogHandlerType.CONSOLE, name);
        }
    }

    public static final class LogHandler {
        private static final LogHandler INSTANCE = new LogHandler();

        private LogHandler() {
        }

        public ConsoleLogHandler console() {
            return ConsoleLogHandler.INSTANCE;
        }

        public PeriodicRotatingFileLogHandler periodicRotatingFile() {
            return PeriodicRotatingFileLogHandler.INSTANCE;
        }
    }

    public static final class Logger {
        private static final Logger INSTANCE = new Logger();

        private Logger() {
        }

        public AddLogger.Builder add(String category) {
            return new AddLogger.Builder(category);
        }

        public ChangeLogger.Builder change(String category) {
            return new ChangeLogger.Builder(category);
        }

        public RemoveLogger remove(String category) {
            return new RemoveLogger(category);
        }
    }

    public static final class RootLogger {
        private static final RootLogger INSTANCE = new RootLogger();

        private RootLogger() {
        }

        public ChangeRootLogger.Builder change() {
            return new ChangeRootLogger.Builder();
        }
    }
}

