/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.security.realms.AbstractAddSecurityRealmSubElement;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class AddSslServerIdentity
extends AbstractAddSecurityRealmSubElement {
    private final String keystorePassword;
    private final String alias;
    private final List<String> enabledCipherSuites;
    private final List<String> enabledProtocols;
    private final String keyPassword;
    private final String keystorePath;
    private final String keystoreProvider;
    private final String keystoreRelativeTo;
    private final String protocol;

    public AddSslServerIdentity(Builder builder) {
        super(builder);
        this.keystorePassword = builder.keystorePassword;
        this.alias = builder.alias;
        this.enabledCipherSuites = builder.enabledCipherSuites;
        this.enabledProtocols = builder.enabledProtocols;
        this.keyPassword = builder.keyPassword;
        this.keystorePath = builder.keystorePath;
        this.keystoreProvider = builder.keystoreProvider;
        this.keystoreRelativeTo = builder.keystoreRelativeTo;
        this.protocol = builder.protocol;
    }

    public final void apply(OfflineCommandContext ctx) throws Exception {
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddSslServerIdentity.class).subtree("management", Subtree.management()).parameter("realmName", this.securityRealmName).parameter("alias", this.alias).parameter("enabledCipherSuites", this.enabledCipherSuites).parameter("enabledProtocols", this.enabledProtocols).parameter("keyPassword", this.keyPassword).parameter("keystorePassword", this.keystorePassword).parameter("keystorePath", this.keystorePath).parameter("keystoreProvider", this.keystoreProvider).parameter("keystoreRelativeTo", this.keystoreRelativeTo).parameter("protocol", this.protocol).parameter("replaceExisting", this.replaceExisting).build()});
    }

    public final void apply(OnlineCommandContext ctx) throws Exception {
        Address sslServerIdentitiesAddress = this.securityRealmAddress.and("server-identity", "ssl");
        Operations ops = new Operations(ctx.client);
        if (this.replaceExisting) {
            boolean secretServerIdentityExists = ops.exists(sslServerIdentitiesAddress);
            if (secretServerIdentityExists) {
                ops.remove(sslServerIdentitiesAddress);
            }
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(this.securityRealmAddress.and("server-identity", "ssl"), Values.empty().andOptional("alias", this.alias).andListOptional(String.class, "enabled-cipher-suites", this.enabledCipherSuites).andListOptional(String.class, "enabled-protocols", this.enabledProtocols).andOptional("key-password", this.keyPassword).and("keystore-password", this.keystorePassword).andOptional("keystore-path", this.keystorePath).andOptional("keystore-provider", this.keystoreProvider).andOptional("keystore-relative-to", this.keystoreRelativeTo).andOptional("protocol", this.protocol));
    }

    public static final class Builder
    extends AbstractAddSecurityRealmSubElement.Builder<Builder> {
        private String keystorePassword;
        private String alias;
        private List<String> enabledCipherSuites;
        private List<String> enabledProtocols;
        private String keyPassword;
        private String keystorePath;
        private String keystoreProvider;
        private String keystoreRelativeTo;
        private String protocol;

        public Builder(String securityRealmName) {
            super(securityRealmName);
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder cipherSuitesToEnable(String ... cipherSuitesToEnable) {
            if (this.enabledCipherSuites == null && cipherSuitesToEnable != null) {
                this.enabledCipherSuites = new ArrayList<String>();
            }
            if (cipherSuitesToEnable != null) {
                this.enabledCipherSuites.addAll(Arrays.asList(cipherSuitesToEnable));
            }
            return this;
        }

        public Builder protocolsToEnable(String ... protocolsToEnable) {
            if (this.enabledProtocols == null && protocolsToEnable != null) {
                this.enabledProtocols = new ArrayList<String>();
            }
            if (protocolsToEnable != null) {
                this.enabledProtocols.addAll(Arrays.asList(protocolsToEnable));
            }
            return this;
        }

        public Builder keystorePassword(String keystorePassword) {
            this.keystorePassword = keystorePassword;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder keystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this;
        }

        public Builder keystoreProvider(String keystoreProvider) {
            this.keystoreProvider = keystoreProvider;
            return this;
        }

        public Builder keystoreRelativeTo(String keystoreRelativeTo) {
            this.keystoreRelativeTo = keystoreRelativeTo;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public AddSslServerIdentity build() {
            if (this.keystorePassword == null) {
                throw new IllegalArgumentException("keystorePassword is manadatory");
            }
            return new AddSslServerIdentity(this);
        }
    }
}

