/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.patching;

import java.util.List;

final class PatchingConversions {
    private PatchingConversions() {
    }

    public static String flatten(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument list must be provided");
        }
        StringBuilder sb = new StringBuilder();
        for (String p : list) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p);
        }
        return sb.toString();
    }

    public static String flattenAndEscape(List<String> paths) {
        if (paths == null) {
            throw new IllegalArgumentException("Argument paths must be provided");
        }
        StringBuilder sb = new StringBuilder();
        for (String p : paths) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p.replaceAll("\\\\", "\\\\\\\\"));
        }
        return sb.toString();
    }
}

