/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.ra;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddConnectionFactoryToRA
implements OnlineCommand {
    private final String poolName;
    private final String localJndiName;
    private final String resourceAdapterId;
    private final String userName;
    private final String password;
    private final Map<String, String> properties;
    private final boolean security;
    private final boolean tracking;

    private AddConnectionFactoryToRA(Builder builder) {
        this.poolName = builder.poolName;
        this.localJndiName = builder.localJndiName;
        this.resourceAdapterId = builder.resourceAdapterId;
        this.userName = builder.userName;
        this.password = builder.password;
        this.security = builder.security;
        this.properties = builder.properties;
        this.tracking = builder.tracking;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Batch batch = new Batch();
        Address address = Address.subsystem((String)"resource-adapters").and("resource-adapter", this.resourceAdapterId).and("connection-definitions", this.poolName);
        batch.add(address, Values.of((String)"class-name", (String)"org.jboss.resource.adapter.jms.JmsManagedConnectionFactory").and("jndi-name", this.localJndiName));
        if (this.security) {
            batch.writeAttribute(address, "security-application", true);
        }
        if (this.userName != null) {
            batch.writeAttribute(address, "recovery-username", this.userName);
        }
        if (this.password != null) {
            batch.writeAttribute(address, "recovery-password", this.password);
        }
        batch.writeAttribute(address, "tracking", this.tracking);
        for (Map.Entry<String, String> pair : this.properties.entrySet()) {
            Address configPropsAddress = Address.subsystem((String)"resource-adapters").and("resource-adapter", this.resourceAdapterId).and("connection-definitions", this.poolName).and("config-properties", pair.getKey());
            batch.add(configPropsAddress, Values.of((String)"value", (String)pair.getValue()));
        }
        new Operations(ctx.client).batch(batch);
    }

    public String toString() {
        return "AddConnectionFactoryToRA " + this.poolName;
    }

    public static final class Builder {
        private final String poolName;
        private final String localJndiName;
        private final String resourceAdapterId;
        private String userName;
        private String password;
        private boolean security = false;
        private boolean tracking = true;
        private Map<String, String> properties = new HashMap<String, String>();

        public Builder(String poolName, String localJndiName, String resourceAdapterId) {
            if (poolName == null) {
                throw new IllegalArgumentException("poolName must be specified");
            }
            if (localJndiName == null) {
                throw new IllegalArgumentException("localJndiName must be specified");
            }
            if (resourceAdapterId == null) {
                throw new IllegalArgumentException("resourceAdapterId must be specified");
            }
            this.poolName = poolName;
            this.localJndiName = localJndiName;
            this.resourceAdapterId = resourceAdapterId;
        }

        public Builder addXARecovery(String userName, String password) {
            this.userName = userName;
            this.password = password;
            return this;
        }

        public Builder setApplicationSecurity(boolean applicationSecurity) {
            this.security = applicationSecurity;
            return this;
        }

        public Builder addProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder setTracking(boolean tracking) {
            this.tracking = tracking;
            return this;
        }

        public AddConnectionFactoryToRA build() {
            return new AddConnectionFactoryToRA(this);
        }
    }
}

