/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.foundation.online;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.wildfly.extras.creaper.commands.foundation.online.CliScript;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public final class CliFile
implements OnlineCommand {
    private final CharSource source;
    private final String description;

    public CliFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must be provided");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + file);
        }
        this.source = Files.asByteSource((File)file).asCharSource(Charsets.UTF_8);
        this.description = file.toString();
    }

    public CliFile(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("A class of the script must be provided");
        }
        String path = clazz.getSimpleName() + ".cli";
        URL url = Resources.getResource((Class)clazz, (String)path);
        this.source = Resources.asByteSource((URL)url).asCharSource(Charsets.UTF_8);
        this.description = path;
    }

    public CliFile(Class resourceLoader, String path) {
        if (resourceLoader == null) {
            throw new IllegalArgumentException("A class for loading the script must be provided");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path to the script must be provided");
        }
        URL url = Resources.getResource((Class)resourceLoader, (String)path);
        this.source = Resources.asByteSource((URL)url).asCharSource(Charsets.UTF_8);
        this.description = path;
    }

    public void apply(OnlineCommandContext ctx) throws IOException, CliException, CommandFailedException {
        ctx.client.apply(new OnlineCommand[]{new CliScript(this.source.read(), this.description)});
    }

    public String toString() {
        return "CliFile " + this.description;
    }
}

