/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wildfly.extras.creaper.core.online.OnlineCommand;

abstract class AbstractAddPrincipalDecoder
implements OnlineCommand {
    protected final String name;
    protected final List<String> principalDecoders;
    protected final boolean replaceExisting;

    protected AbstractAddPrincipalDecoder(Builder builder) {
        this.name = builder.name;
        this.principalDecoders = builder.principalDecoders;
        this.replaceExisting = builder.replaceExisting;
    }

    static abstract class Builder<THIS extends Builder> {
        protected final String name;
        protected final List<String> principalDecoders = new ArrayList<String>();
        private boolean replaceExisting;

        public Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of the aggregate-principal-decoder must be specified as non null value");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name of the aggregate-principal-decoder must not be empty value");
            }
            this.name = name;
        }

        public final THIS principalDecoders(String ... principalDecoders) {
            if (principalDecoders == null) {
                throw new IllegalArgumentException("Principal decoder added to aggregate-principal-decoder must not be null");
            }
            Collections.addAll(this.principalDecoders, principalDecoders);
            return (THIS)this;
        }

        public final THIS replaceExisting() {
            this.replaceExisting = true;
            return (THIS)this;
        }

        public abstract AbstractAddPrincipalDecoder build();
    }
}

