/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.orb;

final class Attribute<T> {
    private final T value;
    private final boolean isToUndefine;

    private Attribute(T value) {
        this.value = value;
        this.isToUndefine = false;
    }

    private Attribute(T value, boolean isToUndefine) {
        this.value = value;
        this.isToUndefine = isToUndefine;
    }

    public static <T> Attribute<T> noValue() {
        return new Attribute<Object>(null);
    }

    public static <T> Attribute<T> undefine() {
        return new Attribute<Object>(null, true);
    }

    public static Attribute<String> undefineString() {
        return new Attribute<Object>(null, true);
    }

    public static <T> Attribute<T> of(T referenceValue) {
        return new Attribute<T>(referenceValue);
    }

    public T get() {
        return this.value;
    }

    public boolean isUndefine() {
        return this.isToUndefine;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasNoValue() {
        return this.value == null;
    }

    public boolean isAbsent() {
        return this.hasNoValue() && !this.isUndefine();
    }
}

