/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron;

import java.util.Arrays;
import java.util.List;
import org.wildfly.extras.creaper.commands.elytron.CredentialRef;
import org.wildfly.extras.creaper.commands.elytron.tls.AddKeyManager;
import org.wildfly.extras.creaper.commands.elytron.tls.AddKeyStore;
import org.wildfly.extras.creaper.commands.elytron.tls.AddServerSSLContext;
import org.wildfly.extras.creaper.commands.elytron.tls.AddTrustManager;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public final class CreateServerSSLContext
implements OnlineCommand {
    private static final String KEY_STORE_NAME = "key-store-name";
    private static final String TRUST_STORE_NAME = "trust-store-name";
    private static final String KEY_MANAGER_NAME = "key-manager-name";
    private static final String TRUST_MANAGER_NAME = "trust-manager-name";
    private final String name;
    protected final List<String> protocols;
    private final String cipherSuiteFilter;
    private final String cipherSuiteNames;
    private final Boolean needClientAuth;
    private final Boolean wantClientAuth;
    private final Boolean authenticationOptional;
    private final String securityDomain;
    private final Integer maximumSessionCacheSize;
    private final Integer sessionTimeout;
    private final String providers;
    private final String keyStoreType;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String keyPassword;
    private final String keyStoreAlias;
    private final String keyStoreRelativeTo;
    private final Boolean keyStoreRequired;
    private final String keyStoreProviders;
    private final String keyManagerProviders;
    private final String trustStoreType;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String trustStoreAlias;
    private final String trustStoreRelativeTo;
    private final Boolean trustStoreRequired;
    private final String trustStoreProviders;
    private final String trustManagerProviders;
    private final String algorithm;
    public static final String TLS13_CIPHER_SUITE_NAMES = "TLS_AES_256_GCM_SHA384:TLS_CHACHA20_POLY1305_SHA256:TLS_AES_128_GCM_SHA256";

    private CreateServerSSLContext(Builder builder) {
        this.name = builder.name;
        this.keyStoreType = builder.keyStoreType;
        this.keyStorePath = builder.keyStorePath;
        this.keyStorePassword = builder.keyStorePassword;
        this.keyPassword = builder.keyPassword;
        this.trustStoreType = builder.trustStoreType;
        this.trustStorePath = builder.trustStorePath;
        this.trustStorePassword = builder.trustStorePassword;
        this.protocols = builder.protocols;
        this.cipherSuiteFilter = builder.cipherSuiteFilter;
        this.cipherSuiteNames = builder.cipherSuiteNames;
        this.needClientAuth = builder.needClientAuth;
        this.wantClientAuth = builder.wantClientAuth;
        this.authenticationOptional = builder.authenticationOptional;
        this.securityDomain = builder.securityDomain;
        this.maximumSessionCacheSize = builder.maximumSessionCacheSize;
        this.sessionTimeout = builder.sessionTimeout;
        this.keyStoreAlias = builder.keyStoreAlias;
        this.keyStoreRelativeTo = builder.keyStoreRelativeTo;
        this.keyStoreRequired = builder.keyStoreRequired;
        this.trustStoreAlias = builder.trustStoreAlias;
        this.trustStoreRelativeTo = builder.trustStoreRelativeTo;
        this.trustStoreRequired = builder.trustStoreRequired;
        this.algorithm = builder.algorithm;
        this.trustStoreProviders = builder.trustStoreProviders;
        this.keyStoreProviders = builder.keyStoreProviders;
        this.keyManagerProviders = builder.keyManagerProviders;
        this.trustManagerProviders = builder.trustManagerProviders;
        this.providers = builder.providers;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        AddKeyStore addKeyStore = new AddKeyStore.Builder(this.getUniqueName(KEY_STORE_NAME)).type(this.keyStoreType).path(this.keyStorePath).relativeTo(this.keyStoreRelativeTo).required(this.keyStoreRequired).aliasFilter(this.keyStoreAlias).providers(this.keyStoreProviders).credentialReference(new CredentialRef.CredentialRefBuilder().clearText(this.keyStorePassword).build()).build();
        AddKeyManager addKeyManager = new AddKeyManager.Builder(this.getUniqueName(KEY_MANAGER_NAME)).keyStore(this.getUniqueName(KEY_STORE_NAME)).algorithm(this.algorithm).providers(this.keyManagerProviders).credentialReference(new CredentialRef.CredentialRefBuilder().clearText(this.keyPassword).build()).build();
        AddKeyStore addTrustStore = null;
        AddTrustManager addTrustManager = null;
        if (this.isTrustStoreConfigured()) {
            addTrustStore = new AddKeyStore.Builder(this.getUniqueName(TRUST_STORE_NAME)).type(this.trustStoreType).path(this.trustStorePath).relativeTo(this.trustStoreRelativeTo).required(this.trustStoreRequired).aliasFilter(this.trustStoreAlias).providers(this.trustStoreProviders).credentialReference(new CredentialRef.CredentialRefBuilder().clearText(this.trustStorePassword).build()).build();
            addTrustManager = new AddTrustManager.Builder(this.getUniqueName(TRUST_MANAGER_NAME)).algorithm(this.algorithm).providers(this.trustManagerProviders).keyStore(this.getUniqueName(TRUST_STORE_NAME)).build();
        }
        AddServerSSLContext.Builder sslServerContextBuilder = (AddServerSSLContext.Builder)((AddServerSSLContext.Builder)((AddServerSSLContext.Builder)((AddServerSSLContext.Builder)((AddServerSSLContext.Builder)new AddServerSSLContext.Builder(this.name).protocols(this.protocols == null ? null : this.protocols.toArray(new String[this.protocols.size()]))).cipherSuiteFilter(this.cipherSuiteFilter)).cipherSuiteNames(this.cipherSuiteNames)).needClientAuth(this.needClientAuth).sessionTimeout(this.sessionTimeout).maximumSessionCacheSize(this.maximumSessionCacheSize).securityDomain(this.securityDomain).authenticationOptional(this.authenticationOptional).wantClientAuth(this.wantClientAuth).providers(this.providers)).keyManager(this.getUniqueName(KEY_MANAGER_NAME));
        if (this.isTrustStoreConfigured()) {
            sslServerContextBuilder.trustManager(this.getUniqueName(TRUST_MANAGER_NAME));
        }
        ctx.client.apply(new OnlineCommand[]{addKeyStore});
        ctx.client.apply(new OnlineCommand[]{addKeyManager});
        if (this.isTrustStoreConfigured()) {
            ctx.client.apply(new OnlineCommand[]{addTrustStore});
            ctx.client.apply(new OnlineCommand[]{addTrustManager});
        }
        ctx.client.apply(new OnlineCommand[]{sslServerContextBuilder.build()});
    }

    public static String getTrustManagerName(String serverSslContextName) {
        return CreateServerSSLContext.getUniqueName(TRUST_MANAGER_NAME, serverSslContextName);
    }

    public static String getKeyManagerName(String serverSslContextName) {
        return CreateServerSSLContext.getUniqueName(KEY_MANAGER_NAME, serverSslContextName);
    }

    public static String getKeyStoreName(String serverSslContext) {
        return CreateServerSSLContext.getUniqueName(KEY_STORE_NAME, serverSslContext);
    }

    public static String getTrustStoreName(String serverSslContext) {
        return CreateServerSSLContext.getUniqueName(TRUST_STORE_NAME, serverSslContext);
    }

    private boolean isTrustStoreConfigured() {
        return this.trustStorePassword != null && !this.trustStorePassword.isEmpty();
    }

    private String getUniqueName(String resourceNameBase) {
        return CreateServerSSLContext.getUniqueName(resourceNameBase, this.name);
    }

    private static String getUniqueName(String resourceNameBase, String sslContextName) {
        return resourceNameBase + "_" + sslContextName;
    }

    public static final class Builder {
        private String name;
        private List<String> protocols;
        private String cipherSuiteFilter;
        private String cipherSuiteNames;
        private Boolean needClientAuth;
        private Boolean wantClientAuth;
        private Boolean authenticationOptional;
        private String securityDomain;
        private Integer maximumSessionCacheSize;
        private Integer sessionTimeout;
        private String providers;
        private String keyStoreType = "JKS";
        private String keyStorePath;
        private String keyStorePassword;
        private String keyPassword;
        private String keyStoreAlias;
        private String keyStoreRelativeTo;
        private Boolean keyStoreRequired;
        private String keyStoreProviders;
        private String keyManagerProviders;
        private String trustStoreType = "JKS";
        private String trustStorePath;
        private String trustStorePassword;
        private String trustStoreAlias;
        private String trustStoreRelativeTo;
        private Boolean trustStoreRequired;
        private String trustStoreProviders;
        private String trustManagerProviders;
        private String algorithm;

        public Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of the ssl-context must be specified as non null value");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name of the ssl-context must not be empty value");
            }
            this.name = name;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder protocols(String ... protocols) {
            if (protocols != null && protocols.length > 0) {
                this.protocols = Arrays.asList(protocols);
            }
            return this;
        }

        public Builder cipherSuiteFilter(String cipherSuiteFilter) {
            this.cipherSuiteFilter = cipherSuiteFilter;
            return this;
        }

        public Builder cipherSuiteNames(String cipherSuiteNames) {
            this.cipherSuiteNames = cipherSuiteNames;
            return this;
        }

        public Builder needClientAuth(Boolean needClientAuth) {
            this.needClientAuth = needClientAuth;
            return this;
        }

        public Builder wantClientAuth(Boolean wantClientAuth) {
            this.wantClientAuth = wantClientAuth;
            return this;
        }

        public Builder authenticationOptional(Boolean authenticationOptional) {
            this.authenticationOptional = authenticationOptional;
            return this;
        }

        public Builder securityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public Builder maximumSessionCacheSize(Integer maximumSessionCacheSize) {
            this.maximumSessionCacheSize = maximumSessionCacheSize;
            return this;
        }

        public Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder keyStoreAlias(String keyStoreAlias) {
            this.keyStoreAlias = keyStoreAlias;
            return this;
        }

        public Builder keyStoreRelativeTo(String keyStoreRelativeTo) {
            this.keyStoreRelativeTo = keyStoreRelativeTo;
            return this;
        }

        public Builder keyStoreRequired(Boolean keyStoreRequired) {
            this.keyStoreRequired = keyStoreRequired;
            return this;
        }

        public Builder trustStoreAlias(String trustStoreAlias) {
            this.trustStoreAlias = trustStoreAlias;
            return this;
        }

        public Builder trustStoreRelativeTo(String trustStoreRelativeTo) {
            this.trustStoreRelativeTo = trustStoreRelativeTo;
            return this;
        }

        public Builder trustStoreRequired(Boolean trustStoreRequired) {
            this.trustStoreRequired = trustStoreRequired;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder trustStoreProviders(String trustStoreProviders) {
            this.trustStoreProviders = trustStoreProviders;
            return this;
        }

        public Builder keyStoreProviders(String keyStoreProviders) {
            this.keyStoreProviders = keyStoreProviders;
            return this;
        }

        public Builder keyManagerProviders(String keyManagerProviders) {
            this.keyManagerProviders = keyManagerProviders;
            return this;
        }

        public Builder trustManagerProviders(String trustManagerProviders) {
            this.trustManagerProviders = trustManagerProviders;
            return this;
        }

        public Builder providers(String providers) {
            this.providers = providers;
            return this;
        }

        public Builder providersAll(String providersAll) {
            this.keyStoreProviders = providersAll;
            this.trustStoreProviders = providersAll;
            this.keyManagerProviders = providersAll;
            this.trustManagerProviders = providersAll;
            this.providers = providersAll;
            return this;
        }

        public CreateServerSSLContext build() {
            if (this.keyStorePassword == null || this.keyStorePassword.isEmpty()) {
                throw new IllegalArgumentException("Key store password of the ssl-context must not be empty value");
            }
            if (this.keyPassword == null || this.keyPassword.isEmpty()) {
                throw new IllegalArgumentException("Key store item password of the ssl-context must not be empty value");
            }
            return new CreateServerSSLContext(this);
        }
    }
}

