/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.ra;

import org.wildfly.extras.creaper.commands.ra.TransactionType;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddResourceAdapter
implements OnlineCommand {
    private final String id;
    private final String module;
    private final String transactions;

    private AddResourceAdapter(Builder builder) {
        this.id = builder.resourceAdapterId;
        this.module = builder.module;
        switch (builder.transactions) {
            case NONE: {
                this.transactions = TransactionType.NONE.getValue();
                break;
            }
            case XA: {
                this.transactions = TransactionType.XA.getValue();
                break;
            }
            default: {
                this.transactions = TransactionType.NONE.getValue();
            }
        }
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address address = Address.subsystem((String)"resource-adapters").and("resource-adapter", this.id);
        ops.add(address, Values.of((String)"transaction-support", (String)this.transactions).and("module", this.module).and("slot", "main"));
    }

    public String toString() {
        return "AddResourceAdapter " + this.id;
    }

    public static final class Builder {
        private final String resourceAdapterId;
        private final String module;
        private final TransactionType transactions;

        public Builder(String resourceAdapterId, String resourceAdapterModule, TransactionType transactionSupport) {
            if (resourceAdapterId == null) {
                throw new IllegalArgumentException("resourceAdapterId must be specified");
            }
            if (resourceAdapterModule == null) {
                throw new IllegalArgumentException("resourceAdapterModule must be specified");
            }
            if (transactionSupport == null) {
                throw new IllegalArgumentException("transactionSupport must be specified");
            }
            this.resourceAdapterId = resourceAdapterId;
            this.module = resourceAdapterModule;
            this.transactions = transactionSupport;
        }

        public AddResourceAdapter build() {
            return new AddResourceAdapter(this);
        }
    }
}

