/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.security.realms.AbstractAddSecurityRealmSubElement;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public class AddTruststoreAuthentication
extends AbstractAddSecurityRealmSubElement {
    private final String truststorePassword;
    private String truststorePath;
    private String truststoreProvider;
    private String truststoreRelativeTo;

    public AddTruststoreAuthentication(Builder builder) {
        super(builder);
        this.truststorePassword = builder.truststorePassword;
        this.truststorePath = builder.truststorePath;
        this.truststoreProvider = builder.truststoreProvider;
        this.truststoreRelativeTo = builder.truststoreRelativeTo;
    }

    public final void apply(OfflineCommandContext ctx) throws Exception {
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddTruststoreAuthentication.class).subtree("management", Subtree.management()).parameter("realmName", this.securityRealmName).parameter("truststorePassword", this.truststorePassword).parameter("truststorePath", this.truststorePath).parameter("truststoreProvider", this.truststoreProvider).parameter("truststoreRelativeTo", this.truststoreRelativeTo).parameter("replaceExisting", this.replaceExisting).build()});
    }

    public final void apply(OnlineCommandContext ctx) throws Exception {
        Address truststoreAuthAddress = this.securityRealmAddress.and("authentication", "truststore");
        Operations ops = new Operations(ctx.client);
        if (this.replaceExisting) {
            boolean truststoreAuthExist = ops.exists(truststoreAuthAddress);
            if (truststoreAuthExist) {
                ops.remove(truststoreAuthAddress);
            }
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(truststoreAuthAddress, Values.empty().and("keystore-password", this.truststorePassword).andOptional("keystore-path", this.truststorePath).andOptional("keystore-provider", this.truststoreProvider).andOptional("keystore-relative-to", this.truststoreRelativeTo));
    }

    public static final class Builder
    extends AbstractAddSecurityRealmSubElement.Builder<Builder> {
        private String truststorePassword;
        private String truststorePath;
        private String truststoreProvider;
        private String truststoreRelativeTo;

        public Builder(String securityRealmName) {
            super(securityRealmName);
        }

        public Builder truststorePassword(String truststorePassword) {
            this.truststorePassword = truststorePassword;
            return this;
        }

        public Builder truststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
            return this;
        }

        public Builder truststoreProvider(String truststoreProvider) {
            this.truststoreProvider = truststoreProvider;
            return this;
        }

        public Builder truststoreRelativeTo(String truststoreRelativeTo) {
            this.truststoreRelativeTo = truststoreRelativeTo;
            return this;
        }

        @Override
        public AddTruststoreAuthentication build() {
            if (this.truststorePassword == null) {
                throw new IllegalArgumentException("truststorePassword is manadatory when defining the truststore");
            }
            return new AddTruststoreAuthentication(this);
        }
    }
}

