/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.undertow;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddApplicationSecurityDomain
implements OnlineCommand,
OfflineCommand {
    private final String name;
    private final String httpAuthenticationFactory;
    private final Boolean overrideDeploymentConfig;
    private final boolean replaceExisting;

    private AddApplicationSecurityDomain(Builder builder) {
        this.name = builder.name;
        this.httpAuthenticationFactory = builder.httpAuthenticationFactory;
        this.overrideDeploymentConfig = builder.overrideDeploymentConfig;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        ctx.version.assertAtLeast(ServerVersion.VERSION_5_0_0);
        Operations ops = new Operations(ctx.client);
        Address address = Address.subsystem((String)"undertow").and("application-security-domain", this.name);
        if (this.replaceExisting) {
            ops.removeIfExists(address);
            new Administration(ctx.client).reloadIfRequired();
        }
        Values params = Values.empty().and("http-authentication-factory", this.httpAuthenticationFactory).andOptional("override-deployment-config", this.overrideDeploymentConfig);
        ops.add(address, params);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        ctx.version.assertAtLeast(ServerVersion.VERSION_5_0_0);
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddApplicationSecurityDomain.class).subtree("undertowSubsystem", Subtree.subsystem("undertow")).parameter("atrName", this.name).parameter("atrHttpAuthenticationFactory", this.httpAuthenticationFactory).parameter("atrOverrideDeploymentConfig", this.overrideDeploymentConfig).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder {
        private final String name;
        private String httpAuthenticationFactory;
        private Boolean overrideDeploymentConfig;
        private boolean replaceExisting;

        public Builder(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Name of the application-security-domain must be specified as non empty value");
            }
            this.name = name;
        }

        public Builder httpAuthenticationFactory(String httpAuthenticationFactory) {
            this.httpAuthenticationFactory = httpAuthenticationFactory;
            return this;
        }

        public Builder overrideDeploymentConfig(boolean overrideDeploymentConfig) {
            this.overrideDeploymentConfig = overrideDeploymentConfig;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddApplicationSecurityDomain build() {
            if (this.httpAuthenticationFactory == null || this.httpAuthenticationFactory.isEmpty()) {
                throw new IllegalArgumentException("httpAuthenticationFactory is manadatory");
            }
            return new AddApplicationSecurityDomain(this);
        }
    }
}

