/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddLoginModule
implements OnlineCommand,
OfflineCommand {
    private final String securityDomainName;
    private final String name;
    private final String code;
    private final String flag;
    private final String module;
    private final Map<String, String> moduleOptions;
    private final boolean replaceExisting;

    protected AddLoginModule(Builder builder) {
        this.securityDomainName = builder.securityDomainName;
        this.name = builder.name;
        this.code = builder.code;
        this.flag = builder.flag;
        this.module = builder.module;
        this.moduleOptions = builder.moduleOptions;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws CliException, CommandFailedException, IOException, TimeoutException, InterruptedException {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        Operations ops = new Operations(ctx.client);
        Address authenticationClassicAddress = Address.subsystem((String)"security").and("security-domain", this.securityDomainName).and("authentication", "classic");
        try {
            boolean exists = ops.exists(authenticationClassicAddress);
            if (!exists) {
                ops.add(authenticationClassicAddress);
            }
        }
        catch (OperationException e) {
            throw new IOException("Failed to access or create authentication=classic in security domain " + this.securityDomainName, e);
        }
        Address loginModuleAddress = authenticationClassicAddress.and("login-module", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(loginModuleAddress);
            }
            catch (OperationException e) {
                throw new IOException("Failed to remove existing login module " + this.name + " in security domain " + this.securityDomainName, e);
            }
        }
        ops.add(loginModuleAddress, Values.empty().andOptional("code", this.code).andOptional("flag", this.flag).andOptional("module", this.module).andObjectOptional("module-options", Values.fromMap(this.moduleOptions)));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddLoginModule.class).subtree("securitySubsystem", Subtree.subsystem("security")).parameter("atrSecurityDomainName", this.securityDomainName).parameter("atrName", this.name).parameter("atrCode", this.code).parameter("atrFlag", this.flag).parameter("atrModule", this.module).parameter("atrModuleOptions", this.moduleOptions).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class UsersRolesBuilder
    extends Builder<UsersRolesBuilder> {
        private static final String USERS_ROLES = "UsersRoles";

        public UsersRolesBuilder() {
            super(USERS_ROLES);
        }

        public UsersRolesBuilder(String name) {
            super(USERS_ROLES, name);
        }

        public UsersRolesBuilder usersProperties(String usersProperties) {
            return (UsersRolesBuilder)this.addModuleOption("usersProperties", usersProperties);
        }

        public UsersRolesBuilder rolesProperties(String rolesProperties) {
            return (UsersRolesBuilder)this.addModuleOption("rolesProperties", rolesProperties);
        }

        public UsersRolesBuilder defaultUsersProperties(String defaultUsersProperties) {
            return (UsersRolesBuilder)this.addModuleOption("defaultUsersProperties", defaultUsersProperties);
        }

        public UsersRolesBuilder defaultRolesProperties(String defaultRolesProperties) {
            return (UsersRolesBuilder)this.addModuleOption("defaultRolesProperties", defaultRolesProperties);
        }

        public UsersRolesBuilder roleGroupSeperator(String roleGroupSeperator) {
            return (UsersRolesBuilder)this.addModuleOption("roleGroupSeperator", roleGroupSeperator);
        }
    }

    public static final class SpnegoBuilder
    extends Builder<SpnegoBuilder> {
        private static final String SPNEGO = "SPNEGO";

        public SpnegoBuilder() {
            super(SPNEGO);
        }

        public SpnegoBuilder(String name) {
            super(SPNEGO, name);
        }

        public SpnegoBuilder serverSecurityDomain(String serverSecurityDomain) {
            return (SpnegoBuilder)this.addModuleOption("serverSecurityDomain", serverSecurityDomain);
        }

        public SpnegoBuilder usernamePasswordDomain(String usernamePasswordDomain) {
            return (SpnegoBuilder)this.addModuleOption("usernamePasswordDomain", usernamePasswordDomain);
        }

        public SpnegoBuilder removeRealmFromPrincipal(boolean removeRealmFromPrincipal) {
            return (SpnegoBuilder)this.addModuleOption("removeRealmFromPrincipal", Boolean.toString(removeRealmFromPrincipal));
        }
    }

    public static final class RealmDirectBuilder
    extends Builder<RealmDirectBuilder> {
        private static final String REALM_DIRECT = "RealmDirect";

        public RealmDirectBuilder() {
            super(REALM_DIRECT);
        }

        public RealmDirectBuilder(String name) {
            super(REALM_DIRECT, name);
        }

        public RealmDirectBuilder realm(String realm) {
            return (RealmDirectBuilder)this.addModuleOption("realm", realm);
        }
    }

    public static final class LdapBuilder
    extends Builder<LdapBuilder> {
        private static final String LDAP = "Ldap";

        public LdapBuilder() {
            super(LDAP);
        }

        public LdapBuilder(String name) {
            super(LDAP, name);
        }

        public LdapBuilder javaNamingFactoryInitial(String javaNamingFactoryInitial) {
            return (LdapBuilder)this.addModuleOption("javaNamingFactoryInitial", javaNamingFactoryInitial);
        }

        public LdapBuilder javaNamingProviderUrl(String javaNamingProviderUrl) {
            return (LdapBuilder)this.addModuleOption("javaNamingProviderUrl", javaNamingProviderUrl);
        }

        public LdapBuilder javaNamingSecurityAuthentication(String javaNamingSecurityAuthentication) {
            return (LdapBuilder)this.addModuleOption("javaNamingSecurityAuthentication", javaNamingSecurityAuthentication);
        }

        public LdapBuilder javaNamingSecurityProtocol(String javaNamingSecurityProtocol) {
            return (LdapBuilder)this.addModuleOption("javaNamingSecurityProtocol", javaNamingSecurityProtocol);
        }

        public LdapBuilder javaNamingSecurityPrincipal(String javaNamingSecurityPrincipal) {
            return (LdapBuilder)this.addModuleOption("javaNamingSecurityPrincipal", javaNamingSecurityPrincipal);
        }

        public LdapBuilder javaNamingSecurityCredentials(String javaNamingSecurityCredentials) {
            return (LdapBuilder)this.addModuleOption("javaNamingSecurityCredentials", javaNamingSecurityCredentials);
        }

        public LdapBuilder principalDNPrefix(String principalDNPrefix) {
            return (LdapBuilder)this.addModuleOption("principalDNPrefix", principalDNPrefix);
        }

        public LdapBuilder principalDNSuffix(String principalDNSuffix) {
            return (LdapBuilder)this.addModuleOption("principalDNSuffix", principalDNSuffix);
        }

        public LdapBuilder rolesCtxDN(String rolesCtxDN) {
            return (LdapBuilder)this.addModuleOption("rolesCtxDN", rolesCtxDN);
        }

        public LdapBuilder userRolesCtxDNAttributeName(String userRolesCtxDNAttributeName) {
            return (LdapBuilder)this.addModuleOption("userRolesCtxDNAttributeName", userRolesCtxDNAttributeName);
        }

        public LdapBuilder roleAttributeID(String roleAttributeID) {
            return (LdapBuilder)this.addModuleOption("roleAttributeID", roleAttributeID);
        }

        public LdapBuilder roleAttributeIsDN(boolean roleAttributeIsDN) {
            return (LdapBuilder)this.addModuleOption("roleAttributeIsDN", Boolean.toString(roleAttributeIsDN));
        }

        public LdapBuilder roleNameAttributeID(String roleNameAttributeID) {
            return (LdapBuilder)this.addModuleOption("roleNameAttributeID", roleNameAttributeID);
        }

        public LdapBuilder uidAttributeID(String uidAttributeID) {
            return (LdapBuilder)this.addModuleOption("uidAttributeID", uidAttributeID);
        }

        public LdapBuilder matchOnUserDN(boolean matchOnUserDN) {
            return (LdapBuilder)this.addModuleOption("matchOnUserDN", Boolean.toString(matchOnUserDN));
        }

        public LdapBuilder allowEmptyPasswords(boolean allowEmptyPasswords) {
            return (LdapBuilder)this.addModuleOption("allowEmptyPasswords", Boolean.toString(allowEmptyPasswords));
        }

        public LdapBuilder searchTimeLimit(String searchTimeLimit) {
            return (LdapBuilder)this.addModuleOption("searchTimeLimit", searchTimeLimit);
        }

        public LdapBuilder searchScope(String searchScope) {
            return (LdapBuilder)this.addModuleOption("searchScope", searchScope);
        }

        public LdapBuilder jaasSecurityDomain(String jaasSecurityDomain) {
            return (LdapBuilder)this.addModuleOption("jaasSecurityDomain", jaasSecurityDomain);
        }
    }

    public static final class LdapExtendedBuilder
    extends Builder<LdapExtendedBuilder> {
        private static final String LDAP_EXT = "LdapExtended";

        public LdapExtendedBuilder() {
            super(LDAP_EXT);
        }

        public LdapExtendedBuilder(String name) {
            super(LDAP_EXT, name);
        }

        public LdapExtendedBuilder javaNamingFactoryInitial(String javaNamingFactoryInitial) {
            return (LdapExtendedBuilder)this.addModuleOption("javaNamingFactoryInitial", javaNamingFactoryInitial);
        }

        public LdapExtendedBuilder javaNamingProviderUrl(String javaNamingProviderUrl) {
            return (LdapExtendedBuilder)this.addModuleOption("javaNamingProviderUrl", javaNamingProviderUrl);
        }

        public LdapExtendedBuilder javaNamingSecurityAuthentication(String javaNamingSecurityAuthentication) {
            return (LdapExtendedBuilder)this.addModuleOption("javaNamingSecurityAuthentication", javaNamingSecurityAuthentication);
        }

        public LdapExtendedBuilder javaNamingSecurityProtocol(String javaNamingSecurityProtocol) {
            return (LdapExtendedBuilder)this.addModuleOption("javaNamingSecurityProtocol", javaNamingSecurityProtocol);
        }

        public LdapExtendedBuilder javaNamingSecurityPrincipal(String javaNamingSecurityPrincipal) {
            return (LdapExtendedBuilder)this.addModuleOption("javaNamingSecurityPrincipal", javaNamingSecurityPrincipal);
        }

        public LdapExtendedBuilder javaNamingSecurityCredentials(String javaNamingSecurityCredentials) {
            return (LdapExtendedBuilder)this.addModuleOption("javaNamingSecurityCredentials", javaNamingSecurityCredentials);
        }

        public LdapExtendedBuilder baseCtxDN(String baseCtxDN) {
            return (LdapExtendedBuilder)this.addModuleOption("baseCtxDN", baseCtxDN);
        }

        public LdapExtendedBuilder bindCredential(String bindCredential) {
            return (LdapExtendedBuilder)this.addModuleOption("bindCredential", bindCredential);
        }

        public LdapExtendedBuilder bindDN(String bindDN) {
            return (LdapExtendedBuilder)this.addModuleOption("bindDN", bindDN);
        }

        public LdapExtendedBuilder baseFilter(String baseFilter) {
            return (LdapExtendedBuilder)this.addModuleOption("baseFilter", baseFilter);
        }

        public LdapExtendedBuilder jaasSecurityDomain(String jaasSecurityDomain) {
            return (LdapExtendedBuilder)this.addModuleOption("jaasSecurityDomain", jaasSecurityDomain);
        }

        public LdapExtendedBuilder rolesCtxDN(String rolesCtxDN) {
            return (LdapExtendedBuilder)this.addModuleOption("rolesCtxDN", rolesCtxDN);
        }

        public LdapExtendedBuilder roleFilter(String roleFilter) {
            return (LdapExtendedBuilder)this.addModuleOption("roleFilter", roleFilter);
        }

        public LdapExtendedBuilder roleAttributeID(String roleAttributeID) {
            return (LdapExtendedBuilder)this.addModuleOption("roleAttributeID", roleAttributeID);
        }

        public LdapExtendedBuilder defaultRole(String defaultRole) {
            return (LdapExtendedBuilder)this.addModuleOption("defaultRole", defaultRole);
        }

        public LdapExtendedBuilder usernameBeginString(String usernameBeginString) {
            return (LdapExtendedBuilder)this.addModuleOption("usernameBeginString", usernameBeginString);
        }

        public LdapExtendedBuilder usernameEndString(String usernameEndString) {
            return (LdapExtendedBuilder)this.addModuleOption("usernameEndString", usernameEndString);
        }

        public LdapExtendedBuilder roleNameAttributeID(String roleNameAttributeID) {
            return (LdapExtendedBuilder)this.addModuleOption("roleNameAttributeID", roleNameAttributeID);
        }

        public LdapExtendedBuilder distinguishedNameAttribute(String distinguishedNameAttribute) {
            return (LdapExtendedBuilder)this.addModuleOption("distinguishedNameAttribute", distinguishedNameAttribute);
        }

        public LdapExtendedBuilder roleRecursion(String roleRecursion) {
            return (LdapExtendedBuilder)this.addModuleOption("roleRecursion", roleRecursion);
        }

        public LdapExtendedBuilder searchTimeLimit(String searchTimeLimit) {
            return (LdapExtendedBuilder)this.addModuleOption("searchTimeLimit", searchTimeLimit);
        }

        public LdapExtendedBuilder searchScope(String searchScope) {
            return (LdapExtendedBuilder)this.addModuleOption("searchScope", searchScope);
        }

        public LdapExtendedBuilder referralUserAttributeIDToCheck(String referralUserAttributeIDToCheck) {
            return (LdapExtendedBuilder)this.addModuleOption("referralUserAttributeIDToCheck", referralUserAttributeIDToCheck);
        }

        public LdapExtendedBuilder roleAttributeIsDN(boolean roleAttributeIsDN) {
            return (LdapExtendedBuilder)this.addModuleOption("roleAttributeIsDN", Boolean.toString(roleAttributeIsDN));
        }

        public LdapExtendedBuilder parseRoleNameFromDN(boolean parseRoleNameFromDN) {
            return (LdapExtendedBuilder)this.addModuleOption("parseRoleNameFromDN", Boolean.toString(parseRoleNameFromDN));
        }

        public LdapExtendedBuilder parseUsername(boolean parseUsername) {
            return (LdapExtendedBuilder)this.addModuleOption("parseUsername", Boolean.toString(parseUsername));
        }

        public LdapExtendedBuilder allowEmptyPasswords(boolean allowEmptyPasswords) {
            return (LdapExtendedBuilder)this.addModuleOption("allowEmptyPasswords", Boolean.toString(allowEmptyPasswords));
        }
    }

    public static final class KerberosBuilder
    extends Builder<KerberosBuilder> {
        private static final String KERBEROS = "Kerberos";

        public KerberosBuilder() {
            super(KERBEROS);
        }

        public KerberosBuilder(String name) {
            super(KERBEROS, name);
        }

        public KerberosBuilder delegationCredential(String delegationCredential) {
            return (KerberosBuilder)this.addModuleOption("delegationCredential", delegationCredential);
        }

        public KerberosBuilder credentialLifetime(String credentialLifetime) {
            return (KerberosBuilder)this.addModuleOption("credentialLifetime", credentialLifetime);
        }

        public KerberosBuilder addGSSCredential(boolean addGSSCredential) {
            return (KerberosBuilder)this.addModuleOption("addGSSCredential", Boolean.toString(addGSSCredential));
        }

        public KerberosBuilder wrapGSSCredential(boolean wrapGSSCredential) {
            return (KerberosBuilder)this.addModuleOption("wrapGSSCredential", Boolean.toString(wrapGSSCredential));
        }
    }

    public static final class DatabaseBuilder
    extends Builder<DatabaseBuilder> {
        private static final String DATABASE = "Database";

        public DatabaseBuilder() {
            super(DATABASE);
        }

        public DatabaseBuilder(String name) {
            super(DATABASE, name);
        }

        public DatabaseBuilder dsJndiName(String dsJndiName) {
            return (DatabaseBuilder)this.addModuleOption("dsJndiName", dsJndiName);
        }

        public DatabaseBuilder principalsQuery(String principalsQuery) {
            return (DatabaseBuilder)this.addModuleOption("principalsQuery", principalsQuery);
        }

        public DatabaseBuilder rolesQuery(String rolesQuery) {
            return (DatabaseBuilder)this.addModuleOption("rolesQuery", rolesQuery);
        }

        public DatabaseBuilder transactionManagerJndiName(String transactionManagerJndiName) {
            return (DatabaseBuilder)this.addModuleOption("transactionManagerJndiName", transactionManagerJndiName);
        }

        public DatabaseBuilder suspendResume(boolean suspendResume) {
            return (DatabaseBuilder)this.addModuleOption("suspendResume", Boolean.toString(suspendResume));
        }
    }

    public static final class DatabaseCertificateBuilder
    extends Builder<DatabaseCertificateBuilder> {
        private static final String DATABASE_CERTIFICATE = "DatabaseCertificate";

        public DatabaseCertificateBuilder() {
            super(DATABASE_CERTIFICATE);
        }

        public DatabaseCertificateBuilder(String name) {
            super(DATABASE_CERTIFICATE, name);
        }

        public DatabaseCertificateBuilder securityDomain(String securityDomain) {
            return (DatabaseCertificateBuilder)this.addModuleOption("securityDomain", securityDomain);
        }

        public DatabaseCertificateBuilder verifier(String verifier) {
            return (DatabaseCertificateBuilder)this.addModuleOption("verifier", verifier);
        }

        public DatabaseCertificateBuilder dsJndiName(String dsJndiName) {
            return (DatabaseCertificateBuilder)this.addModuleOption("dsJndiName", dsJndiName);
        }

        public DatabaseCertificateBuilder rolesQuery(String rolesQuery) {
            return (DatabaseCertificateBuilder)this.addModuleOption("rolesQuery", rolesQuery);
        }

        public DatabaseCertificateBuilder transactionManagerJndiName(String transactionManagerJndiName) {
            return (DatabaseCertificateBuilder)this.addModuleOption("transactionManagerJndiName", transactionManagerJndiName);
        }

        public DatabaseCertificateBuilder suspendResume(boolean suspendResume) {
            return (DatabaseCertificateBuilder)this.addModuleOption("suspendResume", Boolean.toString(suspendResume));
        }
    }

    public static final class CertificateRolesBuilder
    extends Builder<CertificateRolesBuilder> {
        private static final String CERTIFICATE_ROLES = "CertificateRoles";

        public CertificateRolesBuilder() {
            super(CERTIFICATE_ROLES);
        }

        public CertificateRolesBuilder(String name) {
            super(CERTIFICATE_ROLES, name);
        }

        public CertificateRolesBuilder securityDomain(String securityDomain) {
            return (CertificateRolesBuilder)this.addModuleOption("securityDomain", securityDomain);
        }

        public CertificateRolesBuilder verifier(String verifier) {
            return (CertificateRolesBuilder)this.addModuleOption("verifier", verifier);
        }

        public CertificateRolesBuilder rolesProperties(String rolesProperties) {
            return (CertificateRolesBuilder)this.addModuleOption("rolesProperties", rolesProperties);
        }

        public CertificateRolesBuilder defaultRolesProperties(String defaultRolesProperties) {
            return (CertificateRolesBuilder)this.addModuleOption("defaultRolesProperties", defaultRolesProperties);
        }

        public CertificateRolesBuilder roleGroupSeparator(String roleGroupSeparator) {
            return (CertificateRolesBuilder)this.addModuleOption("roleGroupSeparator", roleGroupSeparator);
        }
    }

    public static final class CertificateBuilder
    extends Builder<CertificateBuilder> {
        private static final String CERTIFICATE = "Certificate";

        public CertificateBuilder() {
            super(CERTIFICATE);
        }

        public CertificateBuilder(String name) {
            super(CERTIFICATE, name);
        }

        public CertificateBuilder securityDomain(String securityDomain) {
            return (CertificateBuilder)this.addModuleOption("securityDomain", securityDomain);
        }

        public CertificateBuilder verifier(String verifier) {
            return (CertificateBuilder)this.addModuleOption("verifier", verifier);
        }
    }

    public static final class AdvancedLdapBuilder
    extends Builder<AdvancedLdapBuilder> {
        private static final String ADVANCED_LDAP = "AdvancedLdap";

        public AdvancedLdapBuilder() {
            super(ADVANCED_LDAP);
        }

        public AdvancedLdapBuilder(String name) {
            super(ADVANCED_LDAP, name);
        }

        public AdvancedLdapBuilder javaNamingFactoryInitial(String javaNamingFactoryInitial) {
            return (AdvancedLdapBuilder)this.addModuleOption("javaNamingFactoryInitial", javaNamingFactoryInitial);
        }

        public AdvancedLdapBuilder javaNamingProviderUrl(String javaNamingProviderUrl) {
            return (AdvancedLdapBuilder)this.addModuleOption("javaNamingProviderUrl", javaNamingProviderUrl);
        }

        public AdvancedLdapBuilder javaNamingSecurityAuthentication(String javaNamingSecurityAuthentication) {
            return (AdvancedLdapBuilder)this.addModuleOption("javaNamingSecurityAuthentication", javaNamingSecurityAuthentication);
        }

        public AdvancedLdapBuilder javaNamingSecurityProtocol(String javaNamingSecurityProtocol) {
            return (AdvancedLdapBuilder)this.addModuleOption("javaNamingSecurityProtocol", javaNamingSecurityProtocol);
        }

        public AdvancedLdapBuilder javaNamingSecurityPrincipal(String javaNamingSecurityPrincipal) {
            return (AdvancedLdapBuilder)this.addModuleOption("javaNamingSecurityPrincipal", javaNamingSecurityPrincipal);
        }

        public AdvancedLdapBuilder javaNamingSecurityCredentials(String javaNamingSecurityCredentials) {
            return (AdvancedLdapBuilder)this.addModuleOption("javaNamingSecurityCredentials", javaNamingSecurityCredentials);
        }

        public AdvancedLdapBuilder bindDN(String bindDN) {
            return (AdvancedLdapBuilder)this.addModuleOption("bindDN", bindDN);
        }

        public AdvancedLdapBuilder bindCredential(String bindCredential) {
            return (AdvancedLdapBuilder)this.addModuleOption("bindCredential", bindCredential);
        }

        public AdvancedLdapBuilder jaasSecurityDomain(String jaasSecurityDomain) {
            return (AdvancedLdapBuilder)this.addModuleOption("jaasSecurityDomain", jaasSecurityDomain);
        }

        public AdvancedLdapBuilder baseCtxDN(String baseCtxDN) {
            return (AdvancedLdapBuilder)this.addModuleOption("baseCtxDN", baseCtxDN);
        }

        public AdvancedLdapBuilder baseFilter(String baseFilter) {
            return (AdvancedLdapBuilder)this.addModuleOption("baseFilter", baseFilter);
        }

        public AdvancedLdapBuilder searchTimeLimit(String searchTimeLimit) {
            return (AdvancedLdapBuilder)this.addModuleOption("searchTimeLimit", searchTimeLimit);
        }

        public AdvancedLdapBuilder roleAttributeID(String roleAttributeID) {
            return (AdvancedLdapBuilder)this.addModuleOption("roleAttributeID", roleAttributeID);
        }

        public AdvancedLdapBuilder rolesCtxDN(String rolesCtxDN) {
            return (AdvancedLdapBuilder)this.addModuleOption("rolesCtxDN", rolesCtxDN);
        }

        public AdvancedLdapBuilder roleFilter(String roleFilter) {
            return (AdvancedLdapBuilder)this.addModuleOption("roleFilter", roleFilter);
        }

        public AdvancedLdapBuilder roleNameAttributeID(String roleNameAttributeID) {
            return (AdvancedLdapBuilder)this.addModuleOption("roleNameAttributeID", roleNameAttributeID);
        }

        public AdvancedLdapBuilder referralUserAttributeIDToCheck(String referralUserAttributeIDToCheck) {
            return (AdvancedLdapBuilder)this.addModuleOption("referralUserAttributeIDToCheck", referralUserAttributeIDToCheck);
        }

        public AdvancedLdapBuilder searchScope(String searchScope) {
            return (AdvancedLdapBuilder)this.addModuleOption("searchScope", searchScope);
        }

        public AdvancedLdapBuilder bindAuthentication(String bindAuthentication) {
            return (AdvancedLdapBuilder)this.addModuleOption("bindAuthentication", bindAuthentication);
        }

        public AdvancedLdapBuilder roleAttributeIsDN(boolean roleAttributeIsDN) {
            return (AdvancedLdapBuilder)this.addModuleOption("roleAttributeIsDN", Boolean.toString(roleAttributeIsDN));
        }

        public AdvancedLdapBuilder recurseRoles(boolean recurseRoles) {
            return (AdvancedLdapBuilder)this.addModuleOption("recurseRoles", Boolean.toString(recurseRoles));
        }

        public AdvancedLdapBuilder allowEmptyPassword(boolean allowEmptyPassword) {
            return (AdvancedLdapBuilder)this.addModuleOption("allowEmptyPassword", Boolean.toString(allowEmptyPassword));
        }
    }

    public static class Builder<THIS extends Builder> {
        private String securityDomainName;
        private String name;
        private String code;
        private String flag;
        private String module;
        private final Map<String, String> moduleOptions = new LinkedHashMap<String, String>();
        private boolean replaceExisting;

        public Builder(String code) {
            this(code, code);
        }

        public Builder(String code, String name) {
            if (code == null) {
                throw new IllegalArgumentException("Code of the login module must be specified as non null value");
            }
            if (name == null) {
                throw new IllegalArgumentException("Name of the login module must be specified as non null value");
            }
            if (code.isEmpty()) {
                throw new IllegalArgumentException("Code of the login module must not be empty value");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name of the login module must not be empty value");
            }
            this.code = code;
            this.name = name;
        }

        public final THIS securityDomainName(String securityDomainName) {
            this.securityDomainName = securityDomainName;
            return (THIS)this;
        }

        public final THIS flag(String flag) {
            this.flag = flag;
            return (THIS)this;
        }

        public final THIS module(String module) {
            this.module = module;
            return (THIS)this;
        }

        public final THIS addModuleOption(String name, String value) {
            this.moduleOptions.put(name, value);
            return (THIS)this;
        }

        public final THIS replaceExisting() {
            this.replaceExisting = true;
            return (THIS)this;
        }

        public final AddLoginModule build() {
            if (this.securityDomainName == null) {
                throw new IllegalArgumentException("Name of the security-domain must be specified as non null value");
            }
            if (this.securityDomainName.isEmpty()) {
                throw new IllegalArgumentException("Name of the security-domain must not be empty value");
            }
            if (this.flag == null) {
                throw new IllegalArgumentException("Flag of the security-domain must be specified as non null value");
            }
            return new AddLoginModule(this);
        }
    }
}

