/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.patching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.extras.creaper.commands.patching.PatchingConversions;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;

public final class ApplyPatch
implements OnlineCommand {
    private final String patchPath;
    private final Boolean overrideAll;
    private final Boolean overrideModules;
    private final List<String> overridePaths;
    private final List<String> preservePaths;

    private ApplyPatch(Builder builder) {
        this.patchPath = builder.patchPath;
        this.overrideAll = builder.overrideAll;
        this.overrideModules = builder.overrideModules;
        this.overridePaths = builder.overridePaths;
        this.preservePaths = builder.preservePaths;
    }

    public void apply(OnlineCommandContext ctx) throws CliException, CommandFailedException, IOException {
        if (ctx.options.isStandalone && ctx.version.greaterThan(ServerVersion.VERSION_21_0_0)) {
            throw new AssertionError((Object)"Patching has been removed in WildFly 29.");
        }
        StringBuilder cmd = new StringBuilder("patch apply " + this.patchPath);
        if (ctx.options.isDomain) {
            cmd.append(" --host=");
            cmd.append(ctx.options.defaultHost);
        }
        if (this.overrideAll != null && this.overrideAll.booleanValue()) {
            cmd.append(" --override-all");
        }
        if (this.overrideModules != null && this.overrideModules.booleanValue()) {
            cmd.append(" --override-modules");
        }
        if (this.overridePaths != null && !this.overridePaths.isEmpty()) {
            cmd.append(" --override=");
            cmd.append(PatchingConversions.flatten(this.overridePaths));
        }
        if (this.preservePaths != null && !this.preservePaths.isEmpty()) {
            cmd.append(" --preserve=");
            cmd.append(PatchingConversions.flatten(this.preservePaths));
        }
        ctx.client.executeCli(cmd.toString());
    }

    public String toString() {
        return "ApplyPatch " + this.patchPath;
    }

    public static final class Builder {
        private final String patchPath;
        private Boolean overrideAll;
        private Boolean overrideModules;
        private List<String> overridePaths;
        private List<String> preservePaths;

        public Builder(String patchPath) {
            this.patchPath = patchPath;
        }

        public Builder(File patchFile) {
            this.patchPath = patchFile.getAbsolutePath();
        }

        public Builder overrideAll(boolean overrideAll) {
            this.overrideAll = overrideAll;
            return this;
        }

        public Builder overrideModules(boolean overrideModules) {
            this.overrideModules = overrideModules;
            return this;
        }

        public Builder overridePaths(String ... pathsToOverride) {
            if (this.overridePaths == null && pathsToOverride != null) {
                this.overridePaths = new ArrayList<String>();
            }
            if (pathsToOverride != null) {
                this.overridePaths.addAll(Arrays.asList(pathsToOverride));
            }
            return this;
        }

        public Builder preservePaths(String ... pathsToPreserve) {
            if (this.preservePaths == null && pathsToPreserve != null) {
                this.preservePaths = new ArrayList<String>();
            }
            if (pathsToPreserve != null) {
                this.preservePaths.addAll(Arrays.asList(pathsToPreserve));
            }
            return this;
        }

        public ApplyPatch build() {
            return new ApplyPatch(this);
        }
    }
}

