/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.security.realms.AbstractAddSecurityRealmSubElement;
import org.wildfly.extras.creaper.commands.security.realms.LdapCache;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddLdapAuthentication
extends AbstractAddSecurityRealmSubElement {
    private final String advancedFilter;
    private final Boolean allowEmptyPasswords;
    private final String baseDn;
    private final String connection;
    private final Boolean recursive;
    private final String userDn;
    private final String usernameAttribute;
    private final String usernameLoad;
    private final LdapCache cache;

    private AddLdapAuthentication(Builder builder) {
        super(builder);
        this.advancedFilter = builder.advancedFilter;
        this.allowEmptyPasswords = builder.allowEmptyPasswords;
        this.baseDn = builder.baseDn;
        this.connection = builder.connection;
        this.recursive = builder.recursive;
        this.userDn = builder.userDn;
        this.usernameAttribute = builder.usernameAttribute;
        this.usernameLoad = builder.usernameLoad;
        this.cache = builder.cache;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        if (this.usernameLoad != null) {
            ctx.version.assertAtLeast(ServerVersion.VERSION_2_0_0, "Option username-load is available since WildFly 8");
        }
        Operations ops = new Operations(ctx.client);
        Address securityRealmLdapAuthnAddress = this.securityRealmAddress.and("authentication", "ldap");
        if (this.replaceExisting) {
            ops.removeIfExists(securityRealmLdapAuthnAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(securityRealmLdapAuthnAddress, Values.empty().andOptional("username-attribute", this.usernameAttribute).andOptional("advanced-filter", this.advancedFilter).andOptional("connection", this.connection).andOptional("base-dn", this.baseDn).andOptional("user-dn", this.userDn).andOptional("username-load", this.usernameLoad).andOptional("allow-empty-passwords", this.allowEmptyPasswords).andOptional("recursive", this.recursive));
        if (this.cache != null) {
            String cacheType = null;
            if (this.cache.getByAccessTime()) {
                cacheType = "by-access-time";
            }
            if (this.cache.getBySearchTime()) {
                cacheType = "by-search-time";
            }
            ops.add(securityRealmLdapAuthnAddress.and("cache", cacheType), Values.empty().andOptional("cache-failures", this.cache.getCacheFailures()).andOptional("eviction-time", this.cache.getEvictionTime()).andOptional("max-cache-size", this.cache.getMaxCacheSize()));
        }
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        if (this.usernameLoad != null) {
            ctx.version.assertAtLeast(ServerVersion.VERSION_2_0_0, "Option username-load is available since WildFly 8");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddLdapAuthentication.class).subtree("management", Subtree.management()).parameter("atrSecurityRealmName", this.securityRealmName).parameter("atrAdvancedFilter", this.advancedFilter).parameter("atrAllowEmptyPasswords", this.allowEmptyPasswords).parameter("atrBaseDn", this.baseDn).parameter("atrConnection", this.connection).parameter("atrRecursive", this.recursive).parameter("atrUserDn", this.userDn).parameter("atrUsernameAttribute", this.usernameAttribute).parameter("atrUsernameLoad", this.usernameLoad).parameter("atrCache", this.cache).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder
    extends AbstractAddSecurityRealmSubElement.Builder<Builder> {
        private String advancedFilter;
        private Boolean allowEmptyPasswords;
        private String baseDn;
        private String connection;
        private Boolean recursive;
        private String userDn;
        private String usernameAttribute;
        private String usernameLoad;
        private LdapCache cache;

        public Builder(String securityRealmName) {
            super(securityRealmName);
        }

        public Builder advancedFilter(String advancedFilter) {
            this.advancedFilter = advancedFilter;
            return this;
        }

        public Builder allowEmptyPasswords(Boolean allowEmptyPasswords) {
            this.allowEmptyPasswords = allowEmptyPasswords;
            return this;
        }

        public Builder baseDn(String baseDn) {
            this.baseDn = baseDn;
            return this;
        }

        public Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        public Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder userDn(String userDn) {
            this.userDn = userDn;
            return this;
        }

        public Builder usernameAttribute(String usernameAttribute) {
            this.usernameAttribute = usernameAttribute;
            return this;
        }

        public Builder usernameLoad(String usernameLoad) {
            this.usernameLoad = usernameLoad;
            return this;
        }

        public Builder cache(LdapCache cache) {
            this.cache = cache;
            return this;
        }

        @Override
        public AddLdapAuthentication build() {
            if (this.usernameAttribute != null && !this.usernameAttribute.equals("") && this.advancedFilter != null && !this.advancedFilter.equals("")) {
                throw new IllegalArgumentException("Only one of 'username-attribute' or 'advanced-filter' is required.");
            }
            if ((this.usernameAttribute == null || this.usernameAttribute.equals("")) && (this.advancedFilter == null || this.advancedFilter.equals(""))) {
                throw new IllegalArgumentException("One of 'username-attribute' or 'advanced-filter' required.");
            }
            if (this.connection == null) {
                throw new IllegalArgumentException("Connection must be specified as non null value");
            }
            if (this.connection.isEmpty()) {
                throw new IllegalArgumentException("Connection must not be empty value");
            }
            if (this.baseDn == null) {
                throw new IllegalArgumentException("Connection must be specified as non null value");
            }
            if (this.baseDn.isEmpty()) {
                throw new IllegalArgumentException("Connection must not be empty value");
            }
            return new AddLdapAuthentication(this);
        }
    }
}

