/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security.realms;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.security.realms.AbstractAddSecurityRealmSubElement;
import org.wildfly.extras.creaper.commands.security.realms.AdvancedFilter;
import org.wildfly.extras.creaper.commands.security.realms.GroupToPrincipal;
import org.wildfly.extras.creaper.commands.security.realms.LdapCache;
import org.wildfly.extras.creaper.commands.security.realms.PrincipalToGroup;
import org.wildfly.extras.creaper.commands.security.realms.UsernameFilter;
import org.wildfly.extras.creaper.commands.security.realms.UsernameIsDn;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddLdapAuthorization
extends AbstractAddSecurityRealmSubElement {
    private final String connection;
    private final GroupToPrincipal groupToPrincipal;
    private final PrincipalToGroup principalToGroup;
    private final AdvancedFilter advancedFilter;
    private final UsernameFilter usernameFilter;
    private final UsernameIsDn usernameIsDn;

    private AddLdapAuthorization(Builder builder) {
        super(builder);
        this.connection = builder.connection;
        this.groupToPrincipal = builder.groupToPrincipal;
        this.principalToGroup = builder.principalToGroup;
        this.advancedFilter = builder.advancedFilter;
        this.usernameFilter = builder.usernameFilter;
        this.usernameIsDn = builder.usernameIsDn;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        if (this.groupToPrincipal != null && this.groupToPrincipal.preferOriginalConnection != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0))) {
            throw new AssertionError((Object)"Option prefer-original-connection for group-to-principal is available since WildFly 9 or in EAP 6.4.x.");
        }
        if (this.principalToGroup != null) {
            if (this.principalToGroup.skipMissingGroups != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0))) {
                throw new AssertionError((Object)"Option skip-missing-groups for principal-to-group is available since WildFly 9 or in EAP 6.4.x.");
            }
            if (this.principalToGroup.preferOriginalConnection != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.equalTo(ServerVersion.VERSION_2_0_0))) {
                throw new AssertionError((Object)"Option prefer-original-connection for principal-to-group is available since WildFly 8.1.0 or in EAP 6.4.x.");
            }
            if (this.principalToGroup.cache != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0))) {
                throw new AssertionError((Object)"Cache for principal-to-group is available since WildFly 9 or in EAP 6.4.x.");
            }
        }
        Operations ops = new Operations(ctx.client);
        Address securityRealmLdapAuthzAddress = this.securityRealmAddress.and("authorization", "ldap");
        if (this.replaceExisting) {
            ops.removeIfExists(securityRealmLdapAuthzAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        Batch batch = new Batch();
        batch.add(securityRealmLdapAuthzAddress, Values.empty().andOptional("connection", this.connection));
        if (this.groupToPrincipal != null) {
            Address groupToPrincipalAddress = securityRealmLdapAuthzAddress.and("group-search", "group-to-principal");
            batch.add(groupToPrincipalAddress, Values.empty().andOptional("base-dn", this.groupToPrincipal.baseDn).andOptional("group-dn-attribute", this.groupToPrincipal.groupDnAttribute).andOptional("group-name", this.groupToPrincipal.groupName).andOptional("group-name-attribute", this.groupToPrincipal.groupNameAttribute).andOptional("iterative", this.groupToPrincipal.iterative).andOptional("prefer-original-connection", this.groupToPrincipal.preferOriginalConnection).andOptional("principal-attribute", this.groupToPrincipal.principalAttribute).andOptional("recursive", this.groupToPrincipal.recursive).andOptional("search-by", this.groupToPrincipal.searchBy));
            this.addCache(batch, groupToPrincipalAddress, this.groupToPrincipal.cache);
        }
        if (this.principalToGroup != null) {
            Address principalToGroupAddress = securityRealmLdapAuthzAddress.and("group-search", "principal-to-group");
            batch.add(principalToGroupAddress, Values.empty().andOptional("group-attribute", this.principalToGroup.groupAttribute).andOptional("group-dn-attribute", this.principalToGroup.groupDnAttribute).andOptional("group-name", this.principalToGroup.groupName).andOptional("group-name-attribute", this.principalToGroup.groupNameAttribute).andOptional("iterative", this.principalToGroup.iterative).andOptional("prefer-original-connection", this.principalToGroup.preferOriginalConnection).andOptional("skip-missing-groups", this.principalToGroup.skipMissingGroups));
            this.addCache(batch, principalToGroupAddress, this.principalToGroup.cache);
        }
        if (this.advancedFilter != null) {
            Address advancedFilterAddress = securityRealmLdapAuthzAddress.and("username-to-dn", "advanced-filter");
            batch.add(advancedFilterAddress, Values.empty().andOptional("base-dn", this.advancedFilter.baseDn).andOptional("filter", this.advancedFilter.filter).andOptional("force", this.advancedFilter.force).andOptional("recursive", this.advancedFilter.recursive).andOptional("user-dn-attribute", this.advancedFilter.userDnAttribute));
            this.addCache(batch, advancedFilterAddress, this.advancedFilter.cache);
        }
        if (this.usernameFilter != null) {
            Address usernameFilterAddress = securityRealmLdapAuthzAddress.and("username-to-dn", "username-filter");
            batch.add(usernameFilterAddress, Values.empty().andOptional("attribute", this.usernameFilter.attribute).andOptional("base-dn", this.usernameFilter.baseDn).andOptional("force", this.usernameFilter.force).andOptional("recursive", this.usernameFilter.recursive).andOptional("user-dn-attribute", this.usernameFilter.userDnAttribute));
            this.addCache(batch, usernameFilterAddress, this.usernameFilter.cache);
        }
        if (this.usernameIsDn != null) {
            Address usernameIsDnAddress = securityRealmLdapAuthzAddress.and("username-to-dn", "username-is-dn");
            batch.add(usernameIsDnAddress, Values.empty().andOptional("force", this.usernameIsDn.force));
            this.addCache(batch, usernameIsDnAddress, this.usernameIsDn.cache);
        }
        ops.batch(batch);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.greaterThanOrEqualTo(ServerVersion.VERSION_18_0_0)) {
            throw new AssertionError((Object)"Legacy security was removed in WildFly 25.");
        }
        if (this.groupToPrincipal != null && this.groupToPrincipal.preferOriginalConnection != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0))) {
            throw new AssertionError((Object)"Option prefer-original-connection for group-to-principal is available since WildFly 9 or in EAP 6.4.x.");
        }
        if (this.principalToGroup != null) {
            if (this.principalToGroup.skipMissingGroups != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0))) {
                throw new AssertionError((Object)"Option skip-missing-groups for principal-to-group is available since WildFly 9 or in EAP 6.4.x.");
            }
            if (this.principalToGroup.preferOriginalConnection != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.equalTo(ServerVersion.VERSION_2_0_0))) {
                throw new AssertionError((Object)"Option prefer-original-connection for principal-to-group is available since WildFly 8.1.0 or in EAP 6.4.x.");
            }
            if (this.principalToGroup.cache != null && (ctx.version.lessThan(ServerVersion.VERSION_1_7_0) || ctx.version.inRange(ServerVersion.VERSION_2_0_0, ServerVersion.VERSION_2_2_0))) {
                throw new AssertionError((Object)"Cache for principal-to-group is available since WildFly 9 or in EAP 6.4.x.");
            }
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddLdapAuthorization.class).subtree("management", Subtree.management()).parameter("atrSecurityRealmName", this.securityRealmName).parameter("atrConnection", this.connection).parameter("atrReplaceExisting", this.replaceExisting).parameter("atrGroupToPrincipal", this.groupToPrincipal).parameter("atrPrincipalToGroup", this.principalToGroup).parameter("atrAdvancedFilter", this.advancedFilter).parameter("atrUsernameFilter", this.usernameFilter).parameter("atrUsernameIsDn", this.usernameIsDn).build()});
    }

    private void addCache(Batch batch, Address address, LdapCache cache) {
        if (cache != null) {
            String cacheType = null;
            if (cache.getByAccessTime()) {
                cacheType = "by-access-time";
            } else if (cache.getBySearchTime()) {
                cacheType = "by-search-time";
            }
            batch.add(address.and("cache", cacheType), Values.empty().andOptional("cache-failures", cache.getCacheFailures()).andOptional("eviction-time", cache.getEvictionTime()).andOptional("max-cache-size", cache.getMaxCacheSize()));
        }
    }

    public static final class Builder
    extends AbstractAddSecurityRealmSubElement.Builder<Builder> {
        private String connection;
        private GroupToPrincipal groupToPrincipal;
        private PrincipalToGroup principalToGroup;
        private AdvancedFilter advancedFilter;
        private UsernameFilter usernameFilter;
        private UsernameIsDn usernameIsDn;

        public Builder(String securityRealmName) {
            super(securityRealmName);
        }

        public Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        public Builder groupToPrincipal(GroupToPrincipal groupToPrincipal) {
            this.groupToPrincipal = groupToPrincipal;
            return this;
        }

        public Builder principalToGroup(PrincipalToGroup principalToGroup) {
            this.principalToGroup = principalToGroup;
            return this;
        }

        public Builder advancedFilter(AdvancedFilter advancedFilter) {
            this.advancedFilter = advancedFilter;
            return this;
        }

        public Builder usernameFilter(UsernameFilter usernameFilter) {
            this.usernameFilter = usernameFilter;
            return this;
        }

        public Builder usernameIsDn(UsernameIsDn usernameIsDn) {
            this.usernameIsDn = usernameIsDn;
            return this;
        }

        @Override
        public AddLdapAuthorization build() {
            if (this.connection == null) {
                throw new IllegalArgumentException("Connection must be specified as non null value");
            }
            if (this.connection.isEmpty()) {
                throw new IllegalArgumentException("Connection must not be empty value");
            }
            if (this.groupToPrincipal != null && this.principalToGroup != null) {
                throw new IllegalArgumentException("Only one of 'group-to-principal' or 'principal-to-group' is required.");
            }
            if (this.groupToPrincipal == null && this.principalToGroup == null) {
                throw new IllegalArgumentException("One of 'group-to-principal' or 'principal-to-group' is required.");
            }
            if (this.advancedFilter != null && (this.usernameFilter != null || this.usernameIsDn != null) || this.usernameFilter != null && (this.advancedFilter != null || this.usernameIsDn != null) || this.usernameIsDn != null && (this.advancedFilter != null || this.usernameFilter != null)) {
                throw new IllegalArgumentException("Only one of 'advanced-filter','username-filter','username-is-dn' is allowed.");
            }
            return new AddLdapAuthorization(this);
        }
    }
}

