/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.db_bootstrap;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extras.db_bootstrap.DbBootstrapLogger;
import org.wildfly.extras.db_bootstrap.DbBootstrapScanDetectorProcessor;
import org.wildfly.extras.db_bootstrap.DbBootstrapScanDetectorResourceDefinition;

class DbBootstrapScanDetectorAdd
extends AbstractBoottimeAddStepHandler {
    private AtomicInteger priority = new AtomicInteger(0);

    DbBootstrapScanDetectorAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        DbBootstrapScanDetectorResourceDefinition.FILENAME.validateAndSet(operation, model);
        DbBootstrapScanDetectorResourceDefinition.FILTER_ON_NAME.validateAndSet(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        final String filename = model.get("filename").asString();
        final List filterOnName = model.get("filter-on-name").asList();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                DbBootstrapLogger.ROOT_LOGGER.tracef("%s:'%s' %s:'%s'", new Object[]{"filename", filename, "filter-on-name", filterOnName});
                try {
                    processorTarget.addDeploymentProcessor("db_bootstrap", Phase.PARSE, 2816 + DbBootstrapScanDetectorAdd.this.priority.getAndIncrement(), (DeploymentUnitProcessor)new DbBootstrapScanDetectorProcessor(filename, filterOnName));
                }
                catch (Exception e) {
                    DbBootstrapLogger.ROOT_LOGGER.error("Error in instanciating DbBootstraper add handler", e);
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

