/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.db_bootstrap;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoadException;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.scannotation.AnnotationDB;
import org.wildfly.extras.db_bootstrap.DbBootstrapLogger;
import org.wildfly.extras.db_bootstrap.annotations.BootstrapDatabase;
import org.wildfly.extras.db_bootstrap.annotations.BootstrapSchema;
import org.wildfly.extras.db_bootstrap.annotations.UpdateSchema;
import org.wildfly.extras.db_bootstrap.matchfilter.FilenameContainFilter;

class DbBootstrapScanDetectorProcessor
implements DeploymentUnitProcessor {
    public static final String DBBOOTSTRAP_SYSTEM_PROPERTY_PREFIX = "dbbootstrap";
    private final String filename;
    private final FilenameContainFilter filterOnJarFilename;
    private final Set<String> parsedArchived;

    public DbBootstrapScanDetectorProcessor(String filename, List<ModelNode> filterOnName) {
        this.filename = filename;
        this.filterOnJarFilename = !filterOnName.isEmpty() ? new FilenameContainFilter(filterOnName, VisitorAttributes.RECURSE) : null;
        this.parsedArchived = Collections.newSetFromMap(new ConcurrentHashMap());
        DbBootstrapLogger.ROOT_LOGGER.tracef("Archive : %s jar-filter %s", this.filename, (Object)this.filterOnJarFilename);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile root = deploymentRoot.getRoot();
        if (this.parsedArchived.contains(root.getParent().getPathName())) {
            return;
        }
        if (root.getPathName().contains(this.filename)) {
            this.parsedArchived.add(root.getPathName());
            DbBootstrapLogger.ROOT_LOGGER.tracef("match on %s", root.getPathName());
            try {
                URL[] classLoaderurls = this.getJarList(root, false);
                if (classLoaderurls.length > 0) {
                    AnnotationDB db = new AnnotationDB();
                    ClassLoader classLoader = this.addDynamicResources(classLoaderurls, deploymentUnit);
                    if (this.filterOnJarFilename == null) {
                        this.scanForAnnotation(classLoaderurls, db);
                    } else {
                        this.scanForAnnotation(this.getJarList(root, true), db);
                    }
                    this.processAnnotatedFiles(db, classLoader);
                }
            }
            catch (Exception e) {
                DbBootstrapLogger.ROOT_LOGGER.error("Unable to process the internal jar files", e);
            }
        } else {
            DbBootstrapLogger.ROOT_LOGGER.tracef("%s did not match %s", this.filename, root.getPathName());
        }
    }

    private void processAnnotatedFiles(AnnotationDB db, ClassLoader classLoader) throws Exception {
        Map annotationIndex = db.getAnnotationIndex();
        Set databaseBoostrapperClasses = (Set)annotationIndex.get(BootstrapDatabase.class.getName());
        if (databaseBoostrapperClasses != null) {
            HashMap bootstrapMap = new HashMap(databaseBoostrapperClasses.size());
            for (String clazz : databaseBoostrapperClasses) {
                try {
                    Class<?> annotatedClazz = Class.forName(clazz, true, classLoader);
                    BootstrapDatabase dbBoostrapper = annotatedClazz.getAnnotation(BootstrapDatabase.class);
                    bootstrapMap.put(dbBoostrapper, annotatedClazz);
                }
                catch (ClassNotFoundException e) {
                    DbBootstrapLogger.ROOT_LOGGER.error("Unable to find class", e);
                }
            }
            this.processAnnotatedClasses(bootstrapMap, classLoader);
        } else {
            DbBootstrapLogger.ROOT_LOGGER.debug("@BootstrapDatabase annotation was not located in the archive");
        }
    }

    private void processAnnotatedClasses(Map<BootstrapDatabase, Class<?>> bootstrapMap, ClassLoader classLoader) throws Exception {
        ArrayList sortedList = new ArrayList(bootstrapMap.entrySet().size());
        sortedList.addAll(bootstrapMap.entrySet());
        Collections.sort(sortedList, new BootstrapperSorter());
        for (Map.Entry entry : sortedList) {
            this.executeMethod((Class)entry.getValue(), (BootstrapDatabase)entry.getKey(), BootstrapSchema.class, classLoader);
        }
        for (Map.Entry entry : sortedList) {
            this.executeMethod((Class)entry.getValue(), (BootstrapDatabase)entry.getKey(), UpdateSchema.class, classLoader);
        }
    }

    private <T extends Annotation> void executeMethod(Class<?> annotatedClazz, BootstrapDatabase bootstrapDatabaseAnnotation, Class<T> annotation, ClassLoader classLoader) throws Exception {
        Method[] methods;
        for (Method method : methods = annotatedClazz.getDeclaredMethods()) {
            method.setAccessible(true);
            if (method.getAnnotation(annotation) == null) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean sessionParameter = false;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (!parameterTypes[i].equals(Session.class)) continue;
                sessionParameter = true;
                break;
            }
            Object bootstrapClass = annotatedClazz.newInstance();
            if (sessionParameter) {
                this.invokeWithSession(bootstrapDatabaseAnnotation, classLoader, method, bootstrapClass);
                continue;
            }
            method.invoke(bootstrapClass, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeWithSession(BootstrapDatabase bootstrapDatabaseAnnotation, ClassLoader classLoader, Method method, Object bootstrapClass) throws Exception {
        Session session = this.createSession(bootstrapDatabaseAnnotation, classLoader);
        Transaction tx = session.beginTransaction();
        try {
            method.invoke(bootstrapClass, session);
        }
        catch (Exception e) {
            DbBootstrapLogger.ROOT_LOGGER.error(String.format("Unable to invoke method %s ", method.getName()), e);
            tx.rollback();
        }
        finally {
            if (tx.isActive()) {
                tx.commit();
            }
            session.close();
            session.getSessionFactory().close();
        }
    }

    private Session createSession(BootstrapDatabase bootstrapDatabaseAnnotation, ClassLoader classLoader) throws Exception {
        URL resource = classLoader.getResource(bootstrapDatabaseAnnotation.hibernateCfg());
        DbBootstrapLogger.ROOT_LOGGER.tracef("Using hibernate configuration file %s", bootstrapDatabaseAnnotation.hibernateCfg());
        Configuration configuration = new Configuration();
        configuration.configure(resource);
        this.configureSettingsFromSystemProperties(bootstrapDatabaseAnnotation, configuration);
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        SessionFactory sessionFactory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        return sessionFactory.openSession();
    }

    private void configureSettingsFromSystemProperties(BootstrapDatabase bootstrapDatabaseAnnotation, Configuration configuration) {
        String propertyPrefix = String.format("%s.%s", DBBOOTSTRAP_SYSTEM_PROPERTY_PREFIX, bootstrapDatabaseAnnotation.name());
        DbBootstrapLogger.ROOT_LOGGER.tracef("Searching for system properties with prefix %s to set and/or override hibernate configuration properties", propertyPrefix);
        for (Map.Entry<Object, Object> entrySet : System.getProperties().entrySet()) {
            if (!entrySet.getKey().toString().startsWith(propertyPrefix)) continue;
            String hibernatePropertyName = entrySet.getKey().toString().replace(String.format("%s.", propertyPrefix), "");
            String oldHibernatePropertyValue = configuration.getProperty(hibernatePropertyName) == null ? " (New property)" : String.format(" (Replacing existing property with old value=%s)", configuration.getProperty(hibernatePropertyName));
            String newHibernatePropertyValue = entrySet.getValue().toString();
            DbBootstrapLogger.ROOT_LOGGER.tracef("Setting hibernate property: %s=%s%s", hibernatePropertyName, newHibernatePropertyValue, oldHibernatePropertyValue);
            configuration.setProperty(hibernatePropertyName, newHibernatePropertyValue);
        }
    }

    private void scanForAnnotation(URL[] jars, AnnotationDB db) throws IOException, URISyntaxException {
        db.setScanClassAnnotations(true);
        db.setScanFieldAnnotations(false);
        db.setScanMethodAnnotations(false);
        db.setScanParameterAnnotations(false);
        db.scanArchives(jars);
    }

    private URL[] getJarList(VirtualFile deploymentRoot, boolean filter) throws DeploymentUnitProcessingException, IOException {
        List entries = filter ? deploymentRoot.getChildrenRecursively((VirtualFileFilter)this.filterOnJarFilename) : deploymentRoot.getChildrenRecursively();
        int idx = 0;
        URL[] urls = new URL[entries.size()];
        for (VirtualFile virtualFile : entries) {
            urls[idx++] = VFSUtils.getRootURL((VirtualFile)virtualFile);
        }
        return urls;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile root = deploymentRoot.getRoot();
        this.parsedArchived.remove(root.getParent().getPathName());
    }

    private ClassLoader addDynamicResources(URL[] urls, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException, ModuleLoadException {
        return URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
    }

    private static class BootstrapperSorter
    implements Comparator<Map.Entry<BootstrapDatabase, Class<?>>> {
        private BootstrapperSorter() {
        }

        @Override
        public int compare(Map.Entry<BootstrapDatabase, Class<?>> o1, Map.Entry<BootstrapDatabase, Class<?>> o2) {
            int priority2;
            int priority1 = o1.getKey().priority();
            if (priority1 == (priority2 = o2.getKey().priority())) {
                return 0;
            }
            return priority1 > priority2 ? -1 : 1;
        }
    }
}

