/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.db_bootstrap;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extras.db_bootstrap.DbBootstrapExtension;
import org.wildfly.extras.db_bootstrap.DbBootstrapScanDetectorAdd;

class DbBootstrapScanDetectorResourceDefinition
extends PersistentResourceDefinition {
    static final DbBootstrapScanDetectorResourceDefinition INSTANCE = new DbBootstrapScanDetectorResourceDefinition();
    static final SimpleAttributeDefinition FILENAME = new SimpleAttributeDefinitionBuilder("filename", ModelType.STRING, false).build();
    static final StringListAttributeDefinition FILTER_ON_NAME = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("filter-on-name").setAllowNull(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            StringBuilder builder = new StringBuilder();
            if (resourceModel.hasDefined(attribute.getName())) {
                for (ModelNode p : resourceModel.get(attribute.getName()).asList()) {
                    builder.append(p.asString()).append(", ");
                }
            }
            if (builder.length() > 3) {
                builder.setLength(builder.length() - 2);
            }
            if (builder.length() > 0) {
                writer.writeAttribute(attribute.getXmlName(), builder.toString());
            }
        }
    })).build();

    private DbBootstrapScanDetectorResourceDefinition() {
        super(DbBootstrapExtension.SCAN_PATH, (ResourceDescriptionResolver)DbBootstrapExtension.getResolver("config-scan"), (OperationStepHandler)new DbBootstrapScanDetectorAdd(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(FILENAME, FILTER_ON_NAME);
    }
}

