/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.grpc._private.GrpcLogger;

public class GrpcServerService
implements Service {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"grpc-server"});
    private static final long SHUTDOWN_TIMEOUT = 3L;
    private static final String HOST = "localhost";
    private static final int PORT = 9555;
    private static final String KEY_MANAGER = "applicationKM";
    private final String name;
    private final Consumer<GrpcServerService> serverService;
    private final Supplier<ExecutorService> executorService;
    private final Supplier<KeyManager> keyManager;
    private final Map<String, String> serviceClasses;
    private final ClassLoader classLoader;
    private Server server;

    public static void install(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Map<String, String> serviceClasses, ClassLoader classLoader) {
        ServiceName serviceName = deploymentUnit.getServiceName().append(SERVICE_NAME);
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName);
        Consumer serviceConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
        Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)serviceBuilder);
        CapabilityServiceSupport css = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceName keyManagerName = css.getCapabilityServiceName("org.wildfly.security.key-manager", new String[]{KEY_MANAGER});
        Supplier keyManagerSupplier = serviceBuilder.requires(keyManagerName);
        GrpcServerService service = new GrpcServerService(deploymentUnit.getName(), serviceConsumer, executorSupplier, keyManagerSupplier, serviceClasses, classLoader);
        serviceBuilder.setInstance((Service)service);
        serviceBuilder.install();
    }

    private GrpcServerService(String name, Consumer<GrpcServerService> serverService, Supplier<ExecutorService> executorService, Supplier<KeyManager> keyManager, Map<String, String> serviceClasses, ClassLoader classLoader) {
        this.name = name;
        this.serverService = serverService;
        this.executorService = executorService;
        this.keyManager = keyManager;
        this.serviceClasses = serviceClasses;
        this.classLoader = classLoader;
    }

    public void start(StartContext context) {
        context.asynchronous();
        this.executorService.get().submit(() -> {
            try {
                this.startServer();
                context.complete();
            }
            catch (Throwable e) {
                context.failed(new StartException(e));
            }
        });
        this.serverService.accept(this);
    }

    private void startServer() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        GrpcLogger.LOGGER.serverListening(this.name, HOST, 9555);
        NettyServerBuilder serverBuilder = NettyServerBuilder.forPort((int)9555);
        for (String serviceClass : this.serviceClasses.values()) {
            serverBuilder.addService(this.newService(serviceClass));
            GrpcLogger.LOGGER.registerService(serviceClass);
        }
        this.server = serverBuilder.build().start();
    }

    private BindableService newService(String serviceClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = this.classLoader.loadClass(serviceClass);
        Object instance = clazz.newInstance();
        if (!(instance instanceof BindableService)) {
            throw new ClassCastException("gRPC service " + serviceClass + " is not a BindableService!");
        }
        return (BindableService)instance;
    }

    public void stop(StopContext context) {
        GrpcLogger.LOGGER.serverStopping(this.name);
        if (this.server != null) {
            this.stopServer();
        }
        this.serverService.accept(null);
    }

    private void stopServer() {
        try {
            this.server.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

