/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.handlers.Handler;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class FileHandler
extends Handler {
    public static final FileHandler INSTANCE = new FileHandler();
    public static final AttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition CACHE_BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-buffer-size", ModelType.LONG).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1024))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition CACHE_BUFFERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-buffers", ModelType.LONG).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1024))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition DIRECTORY_LISTING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("directory-listing", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition FOLLOW_SYMLINK = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("follow-symlink", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final StringListAttributeDefinition SAFE_SYMLINK_PATHS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("safe-symlink-paths").setRequired(false)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    public static final AttributeDefinition CASE_SENSITIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("case-sensitive", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();

    private FileHandler() {
        super("file");
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(PATH, CACHE_BUFFER_SIZE, CACHE_BUFFERS, DIRECTORY_LISTING, FOLLOW_SYMLINK, CASE_SENSITIVE, SAFE_SYMLINK_PATHS);
    }

    @Override
    public HttpHandler createHandler(OperationContext context, ModelNode model) throws OperationFailedException {
        Path base;
        String path = PATH.resolveModelAttribute(context, model).asString();
        boolean directoryListing = DIRECTORY_LISTING.resolveModelAttribute(context, model).asBoolean();
        boolean followSymlink = FOLLOW_SYMLINK.resolveModelAttribute(context, model).asBoolean();
        boolean caseSensitive = CASE_SENSITIVE.resolveModelAttribute(context, model).asBoolean();
        long cacheBufferSize = CACHE_BUFFER_SIZE.resolveModelAttribute(context, model).asLong();
        long cacheBuffers = CACHE_BUFFERS.resolveModelAttribute(context, model).asLong();
        List safePaths = SAFE_SYMLINK_PATHS.unwrap((ExpressionResolver)context, model);
        String[] paths = safePaths.toArray(new String[safePaths.size()]);
        UndertowLogger.ROOT_LOGGER.creatingFileHandler(path, directoryListing, followSymlink, caseSensitive, safePaths);
        try {
            base = Paths.get(path, new String[0]).normalize().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new OperationFailedException(UndertowLogger.ROOT_LOGGER.unableAddHandlerForPath(path));
        }
        PathResourceManager resourceManager = new PathResourceManager(base, cacheBufferSize * cacheBuffers, caseSensitive, followSymlink, paths);
        ResourceHandler handler = new ResourceHandler((ResourceManager)resourceManager);
        handler.setDirectoryListingEnabled(directoryListing);
        return handler;
    }
}

