/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc.deployment;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.grpc.GrpcServerService;

public class GrpcDeploymentProcessor
implements DeploymentUnitProcessor {
    static final DotName GRPC_SERVICE = DotName.createSimple((String)"org.wildfly.grpc.GrpcService");

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex.getAnnotations(GRPC_SERVICE).isEmpty()) {
            return;
        }
        List serviceAnnotations = compositeIndex.getAnnotations(GRPC_SERVICE);
        if (serviceAnnotations == null || serviceAnnotations.isEmpty()) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        Map<String, String> serviceClasses = serviceAnnotations.stream().filter(annotationInstance -> annotationInstance.target() instanceof ClassInfo).map(annotationInstance -> (ClassInfo)annotationInstance.target()).collect(Collectors.toMap(ClassInfo::simpleName, clazz -> clazz.name().toString()));
        this.processManagement(deploymentUnit, serviceClasses);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        GrpcServerService.install(serviceTarget, deploymentUnit, serviceClasses, (ClassLoader)module.getClassLoader());
    }

    private void processManagement(DeploymentUnit deploymentUnit, Map<String, String> grpcServiceClasses) {
        DeploymentResourceSupport drs = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (Map.Entry<String, String> entry : grpcServiceClasses.entrySet()) {
            ModelNode serviceModel = drs.getDeploymentSubModel("grpc", PathElement.pathElement((String)"grpc-service", (String)entry.getKey()));
            serviceModel.get("service-class").set(entry.getValue());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

