/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.grpc.GrpcSubsystemDefinition;
import org.wildfly.extension.grpc._private.GrpcLogger;

public class GrpcServerService
implements Service {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"grpc-server"});
    private static GrpcServerService grpcServerService;
    private static KeyManager keyManager;
    private static TrustManager trustManager;
    private static SSLContext sslContext;
    private static Object monitor;
    private static boolean restart;
    private static boolean serverRestarting;
    private static Set<SSL_ATTRIBUTE> sslUpdates;
    private static Set<SERVER_ATTRIBUTE> serverUpdates;
    private static int FLOW_CONTROL_WINDOW;
    private static long HANDSHAKE_TIMEOUT;
    private static int INITIAL_FLOW_CONTROL_WINDOW;
    private static long KEEP_ALIVE_TIME;
    private static long KEEP_ALIVE_TIMEOUT;
    private static String KEY_MANAGER_NAME;
    private static int MAX_CONCURRENT_CALLS_PER_CONNECTION;
    private static long MAX_CONNECTION_AGE;
    private static long MAX_CONNECTION_AGE_GRACE;
    private static long MAX_CONNECTION_IDLE;
    private static int MAX_INBOUND_MESSAGE_SIZE;
    private static int MAX_INBOUND_METADATA_SIZE;
    private static long PERMIT_KEEP_ALIVE_TIME;
    private static boolean PERMIT_KEEP_ALIVE_WITHOUT_CALLS;
    private static String PROTOCOL_PROVIDER;
    private static String SERVER_HOST;
    private static int SERVER_PORT;
    private static long SESSION_CACHE_SIZE;
    private static long SESSION_TIMEOUT;
    private static int SHUTDOWN_TIMEOUT;
    private static String SSL_CONTEXT_NAME;
    private static boolean START_TLS;
    private static String TRUST_MANAGER_NAME;
    private final String name;
    private final Consumer<GrpcServerService> serverService;
    private final Supplier<ExecutorService> executorService;
    private final Set<String> serviceClasses = new HashSet<String>();
    private final Set<BindableService> services = new HashSet<BindableService>();
    private Server server;

    static void configure(ModelNode configuration, OperationContext context) throws OperationFailedException {
        Boolean b;
        String s;
        Long l;
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
        serverUpdates.clear();
        Integer n = GrpcSubsystemDefinition.GRPC_FLOW_CONTROL_WINDOW.resolveModelAttribute(context, configuration).asIntOrNull();
        if (n != null && n != FLOW_CONTROL_WINDOW) {
            FLOW_CONTROL_WINDOW = n;
            serverUpdates.add(SERVER_ATTRIBUTE.FLOW_CONTROL_WINDOW);
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_HANDSHAKE_TIMEOUT.resolveModelAttribute(context, configuration).asLongOrNull()) != null && l != HANDSHAKE_TIMEOUT) {
            HANDSHAKE_TIMEOUT = l;
            serverUpdates.add(SERVER_ATTRIBUTE.HANDSHAKE_TIMEOUT);
            restart = true;
        }
        if ((n = GrpcSubsystemDefinition.GRPC_INITIAL_FLOW_CONTROL_WINDOW.resolveModelAttribute(context, configuration).asIntOrNull()) != null && n != INITIAL_FLOW_CONTROL_WINDOW) {
            INITIAL_FLOW_CONTROL_WINDOW = n;
            serverUpdates.add(SERVER_ATTRIBUTE.INITIAL_FLOW_CONTROL_WINDOW);
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_KEEP_ALIVE_TIME.resolveModelAttribute(context, configuration).asLongOrNull()) != null && l != KEEP_ALIVE_TIME) {
            KEEP_ALIVE_TIME = l;
            serverUpdates.add(SERVER_ATTRIBUTE.KEEP_ALIVE_TIME);
            restart = true;
        }
        if ((n = GrpcSubsystemDefinition.GRPC_KEEP_ALIVE_TIMEOUT.resolveModelAttribute(context, configuration).asIntOrNull()) != null && (long)n.intValue() != KEEP_ALIVE_TIMEOUT) {
            KEEP_ALIVE_TIMEOUT = n.intValue();
            serverUpdates.add(SERVER_ATTRIBUTE.KEEP_ALIVE_TIMEOUT);
            restart = true;
        }
        if ((s = GrpcSubsystemDefinition.GRPC_KEY_MANAGER_NAME.resolveModelAttribute(context, configuration).asStringOrNull()) != null && !s.equals(KEY_MANAGER_NAME) || KEY_MANAGER_NAME != null && !KEY_MANAGER_NAME.equals(s)) {
            KEY_MANAGER_NAME = s;
            restart = true;
        }
        if ((n = GrpcSubsystemDefinition.GRPC_MAX_CONCURRENT_CALLS_PER_CONNECTION.resolveModelAttribute(context, configuration).asIntOrNull()) != null && n != MAX_CONCURRENT_CALLS_PER_CONNECTION) {
            MAX_CONCURRENT_CALLS_PER_CONNECTION = n;
            serverUpdates.add(SERVER_ATTRIBUTE.MAX_CONCURRENT_CALLS_PER_CONNECTION);
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_AGE.resolveModelAttribute(context, configuration).asLongOrNull()) != null && l != MAX_CONNECTION_AGE) {
            MAX_CONNECTION_AGE = l;
            serverUpdates.add(SERVER_ATTRIBUTE.MAX_CONNECTION_AGE);
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_AGE_GRACE.resolveModelAttribute(context, configuration).asLongOrNull()) != null && n.longValue() != MAX_CONNECTION_AGE_GRACE) {
            MAX_CONNECTION_AGE_GRACE = l;
            serverUpdates.add(SERVER_ATTRIBUTE.MAX_CONNECTION_AGE_GRACE);
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_IDLE.resolveModelAttribute(context, configuration).asLongOrNull()) != null && l != MAX_CONNECTION_IDLE) {
            MAX_CONNECTION_IDLE = l;
            serverUpdates.add(SERVER_ATTRIBUTE.MAX_CONNECTION_IDLE);
            restart = true;
        }
        if ((n = GrpcSubsystemDefinition.GRPC_MAX_INBOUND_MESSAGE_SIZE.resolveModelAttribute(context, configuration).asIntOrNull()) != null && n != MAX_INBOUND_MESSAGE_SIZE) {
            MAX_INBOUND_MESSAGE_SIZE = n;
            serverUpdates.add(SERVER_ATTRIBUTE.MAX_INBOUND_MESSAGE_SIZE);
            restart = true;
        }
        if ((n = GrpcSubsystemDefinition.GRPC_MAX_INBOUND_METADATA_SIZE.resolveModelAttribute(context, configuration).asIntOrNull()) != null && n != MAX_INBOUND_METADATA_SIZE) {
            MAX_INBOUND_METADATA_SIZE = n;
            serverUpdates.add(SERVER_ATTRIBUTE.MAX_INBOUND_METADATA_SIZE);
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_PERMIT_KEEP_ALIVE_TIME.resolveModelAttribute(context, configuration).asLongOrNull()) != null && l != PERMIT_KEEP_ALIVE_TIME) {
            PERMIT_KEEP_ALIVE_TIME = l;
            serverUpdates.add(SERVER_ATTRIBUTE.PERMIT_KEEP_ALIVE_TIME);
            restart = true;
        }
        if ((b = GrpcSubsystemDefinition.GRPC_PERMIT_KEEP_ALIVE_WITHOUT_CALLS.resolveModelAttribute(context, configuration).asBooleanOrNull()) != null && b != PERMIT_KEEP_ALIVE_WITHOUT_CALLS) {
            PERMIT_KEEP_ALIVE_WITHOUT_CALLS = b;
            serverUpdates.add(SERVER_ATTRIBUTE.PERMIT_KEEP_ALIVE_WITHOUT_CALLS);
            restart = true;
        }
        if ((s = GrpcSubsystemDefinition.GRPC_PROTOCOL_PROVIDER.resolveModelAttribute(context, configuration).asStringOrNull()) != null && !s.equals(PROTOCOL_PROVIDER) || PROTOCOL_PROVIDER != null && !PROTOCOL_PROVIDER.equals(s)) {
            PROTOCOL_PROVIDER = s;
            sslUpdates.add(SSL_ATTRIBUTE.PROTOCOL_PROVIDER);
            restart = true;
        }
        if ((s = GrpcSubsystemDefinition.GRPC_SERVER_HOST.resolveModelAttribute(context, configuration).asStringOrNull()) != null && !s.equals(SERVER_HOST) || SERVER_HOST != null && !SERVER_HOST.equals(s)) {
            SERVER_HOST = s;
            restart = true;
        }
        if ((n = GrpcSubsystemDefinition.GRPC_SERVER_PORT.resolveModelAttribute(context, configuration).asIntOrNull()) != null && n != SERVER_PORT) {
            SERVER_PORT = n;
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_SESSION_CACHE_SIZE.resolveModelAttribute(context, configuration).asLongOrNull()) != null && l != SESSION_CACHE_SIZE) {
            SESSION_CACHE_SIZE = l;
            sslUpdates.add(SSL_ATTRIBUTE.SESSION_CACHE_SIZE);
            restart = true;
        }
        if ((l = GrpcSubsystemDefinition.GRPC_SESSION_TIMEOUT.resolveModelAttribute(context, configuration).asLongOrNull()) != null && l != SESSION_TIMEOUT) {
            SESSION_TIMEOUT = l;
            sslUpdates.add(SSL_ATTRIBUTE.SESSION_TIMEOUT);
            restart = true;
        }
        if ((n = GrpcSubsystemDefinition.GRPC_SHUTDOWN_TIMEOUT.resolveModelAttribute(context, configuration).asIntOrNull()) != null && n != SHUTDOWN_TIMEOUT) {
            SHUTDOWN_TIMEOUT = n;
            restart = true;
        }
        if ((s = GrpcSubsystemDefinition.GRPC_SSL_CONTEXT_NAME.resolveModelAttribute(context, configuration).asStringOrNull()) != null && !s.equals(SSL_CONTEXT_NAME) || SSL_CONTEXT_NAME != null && !SSL_CONTEXT_NAME.equals(s)) {
            SSL_CONTEXT_NAME = s;
            restart = true;
        }
        if ((b = GrpcSubsystemDefinition.GRPC_START_TLS.resolveModelAttribute(context, configuration).asBooleanOrNull()) != null && b != START_TLS) {
            START_TLS = b;
            sslUpdates.add(SSL_ATTRIBUTE.START_TLS);
            restart = true;
        }
        if ((s = GrpcSubsystemDefinition.GRPC_TRUST_MANAGER_NAME.resolveModelAttribute(context, configuration).asStringOrNull()) != null && !s.equals(TRUST_MANAGER_NAME) || TRUST_MANAGER_NAME != null && !TRUST_MANAGER_NAME.equals(s)) {
            TRUST_MANAGER_NAME = s;
            restart = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(ServiceTarget serviceTarget, DeploymentUnit deploymentUnit, Map<String, String> serviceClasses, ClassLoader classLoader) throws Exception {
        if (grpcServerService == null || restart && !serverRestarting) {
            Object object = monitor;
            synchronized (object) {
                if (grpcServerService == null || restart && !serverRestarting) {
                    serverRestarting = true;
                    restart = false;
                    ServiceName serviceName = deploymentUnit.getServiceName().append(SERVICE_NAME);
                    ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName);
                    Consumer serviceConsumer = serviceBuilder.provides(new ServiceName[]{serviceName});
                    Supplier executorSupplier = Services.requireServerExecutor((ServiceBuilder)serviceBuilder);
                    CapabilityServiceSupport css = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                    if (KEY_MANAGER_NAME != null && !"".equals(KEY_MANAGER_NAME)) {
                        ServiceName keyManagerName = css.getCapabilityServiceName("org.wildfly.security.key-manager", new String[]{KEY_MANAGER_NAME});
                        Supplier keyManagerSupplier = serviceBuilder.requires(keyManagerName);
                        if (keyManagerSupplier != null) {
                            keyManager = (KeyManager)keyManagerSupplier.get();
                        }
                    } else {
                        keyManager = null;
                    }
                    if (keyManager != null && SSL_CONTEXT_NAME != null && !"".equals(SSL_CONTEXT_NAME)) {
                        ServiceName sslContextName = css.getCapabilityServiceName("org.wildfly.security.ssl-context", new String[]{SSL_CONTEXT_NAME});
                        Supplier sslContextSupplier = serviceBuilder.requires(sslContextName);
                        if (sslContextSupplier != null) {
                            sslContext = (SSLContext)sslContextSupplier.get();
                        }
                    } else {
                        sslContext = null;
                    }
                    if (keyManager != null && TRUST_MANAGER_NAME != null && !"".equals(TRUST_MANAGER_NAME)) {
                        ServiceName trustManagerName = css.getCapabilityServiceName("org.wildfly.security.trust-manager", new String[]{TRUST_MANAGER_NAME});
                        Supplier trustManagerSupplier = serviceBuilder.requires(trustManagerName);
                        if (trustManagerSupplier != null) {
                            trustManager = (TrustManager)trustManagerSupplier.get();
                        }
                    } else {
                        trustManager = null;
                    }
                    if (grpcServerService != null) {
                        grpcServerService.stopServer();
                    }
                    grpcServerService = new GrpcServerService(deploymentUnit.getName(), serviceConsumer, executorSupplier, serviceClasses, classLoader);
                    serviceBuilder.setInstance((Service)grpcServerService);
                    serviceBuilder.install();
                    return;
                }
            }
        }
        grpcServerService.addServiceClasses(serviceClasses, classLoader);
    }

    private GrpcServerService(String name, Consumer<GrpcServerService> serverService, Supplier<ExecutorService> executorService, Map<String, String> serviceClasses, ClassLoader classLoader) throws Exception {
        this.name = name;
        this.serverService = serverService;
        this.executorService = executorService;
        for (String serviceClass : serviceClasses.values()) {
            this.newService(serviceClass, classLoader, this.serviceClasses, this.services);
        }
    }

    public void start(StartContext context) {
        context.asynchronous();
        this.executorService.get().submit(() -> {
            try {
                this.startServer();
                context.complete();
                serverRestarting = false;
            }
            catch (Throwable e) {
                context.failed(new StartException(e));
            }
        });
        this.serverService.accept(this);
    }

    void addServiceClasses(Map<String, String> serviceClasses, ClassLoader classLoader) throws Exception {
        for (String serviceClass : serviceClasses.values()) {
            this.newService(serviceClass, classLoader, this.serviceClasses, this.services);
        }
    }

    private void startServer() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        GrpcLogger.LOGGER.serverListening(this.name, SERVER_HOST, SERVER_PORT);
        InetSocketAddress socketAddress = new InetSocketAddress(SERVER_HOST, SERVER_PORT);
        NettyServerBuilder serverBuilder = NettyServerBuilder.forAddress((SocketAddress)socketAddress);
        block20: for (SERVER_ATTRIBUTE attr : serverUpdates) {
            switch (attr) {
                case FLOW_CONTROL_WINDOW: {
                    serverBuilder.flowControlWindow(FLOW_CONTROL_WINDOW);
                    continue block20;
                }
                case HANDSHAKE_TIMEOUT: {
                    serverBuilder.handshakeTimeout(HANDSHAKE_TIMEOUT, TimeUnit.SECONDS);
                    continue block20;
                }
                case INITIAL_FLOW_CONTROL_WINDOW: {
                    serverBuilder.initialFlowControlWindow(INITIAL_FLOW_CONTROL_WINDOW);
                    continue block20;
                }
                case KEEP_ALIVE_TIME: {
                    serverBuilder.keepAliveTime(KEEP_ALIVE_TIME, TimeUnit.SECONDS);
                    continue block20;
                }
                case KEEP_ALIVE_TIMEOUT: {
                    serverBuilder.keepAliveTimeout(KEEP_ALIVE_TIMEOUT, TimeUnit.SECONDS);
                    continue block20;
                }
                case KEY_MANAGER_NAME: {
                    continue block20;
                }
                case MAX_CONCURRENT_CALLS_PER_CONNECTION: {
                    serverBuilder.maxConcurrentCallsPerConnection(MAX_CONCURRENT_CALLS_PER_CONNECTION);
                    continue block20;
                }
                case MAX_CONNECTION_AGE: {
                    serverBuilder.maxConnectionAge(MAX_CONNECTION_AGE, TimeUnit.SECONDS);
                    continue block20;
                }
                case MAX_CONNECTION_AGE_GRACE: {
                    serverBuilder.maxConnectionAgeGrace(MAX_CONNECTION_AGE_GRACE, TimeUnit.SECONDS);
                    continue block20;
                }
                case MAX_CONNECTION_IDLE: {
                    serverBuilder.maxConnectionIdle(MAX_CONNECTION_IDLE, TimeUnit.SECONDS);
                    continue block20;
                }
                case MAX_INBOUND_MESSAGE_SIZE: {
                    serverBuilder.maxInboundMessageSize(MAX_INBOUND_MESSAGE_SIZE);
                    continue block20;
                }
                case MAX_INBOUND_METADATA_SIZE: {
                    serverBuilder.maxInboundMetadataSize(MAX_INBOUND_METADATA_SIZE);
                    continue block20;
                }
                case PERMIT_KEEP_ALIVE_TIME: {
                    serverBuilder.permitKeepAliveTime(PERMIT_KEEP_ALIVE_TIME, TimeUnit.SECONDS);
                    continue block20;
                }
                case PERMIT_KEEP_ALIVE_WITHOUT_CALLS: {
                    serverBuilder.permitKeepAliveWithoutCalls(PERMIT_KEEP_ALIVE_WITHOUT_CALLS);
                    continue block20;
                }
                case SERVER_HOST: {
                    continue block20;
                }
                case SERVER_PORT: {
                    continue block20;
                }
                case SHUTDOWN_TIMEOUT: {
                    continue block20;
                }
                case TRUST_MANAGER_NAME: {
                    continue block20;
                }
            }
            GrpcLogger.LOGGER.unknownAttribute(attr.toString());
        }
        if (keyManager != null && !"".equals(keyManager)) {
            serverBuilder.sslContext(this.getSslContext(sslContext));
        }
        for (BindableService serviceClass : this.services) {
            serverBuilder.addService(serviceClass);
        }
        this.server = serverBuilder.build().start();
    }

    private void newService(String serviceClass, ClassLoader classLoader, Set<String> serviceClasses, Set<BindableService> services) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (serviceClasses.contains(serviceClass)) {
            return;
        }
        serviceClasses.add(serviceClass);
        Class<?> clazz = classLoader.loadClass(serviceClass);
        Object instance = clazz.newInstance();
        if (!(instance instanceof BindableService)) {
            throw new ClassCastException("gRPC service " + serviceClass + " is not a BindableService!");
        }
        services.add((BindableService)instance);
    }

    public void stop(StopContext context) {
        GrpcLogger.LOGGER.serverStopping(this.name);
        if (this.server != null) {
            this.stopServer();
        }
        this.serverService.accept(null);
    }

    private void stopServer() {
        try {
            if (this.server != null) {
                this.server.shutdown().awaitTermination((long)SHUTDOWN_TIMEOUT, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private SslContext getSslContext(SSLContext sslContext) throws SSLException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManager)keyManager);
        if (sslContext != null) {
            sslContextBuilder.sslContextProvider(sslContext.getProvider());
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslContextBuilder.ciphers(Arrays.asList(sslEngine.getEnabledCipherSuites()));
            sslContextBuilder.protocols(sslContext.getDefaultSSLParameters().getApplicationProtocols());
            if (trustManager != null) {
                sslContextBuilder.trustManager(trustManager);
            }
        }
        block6: for (SSL_ATTRIBUTE attr : sslUpdates) {
            switch (attr) {
                case PROTOCOL_PROVIDER: {
                    sslContextBuilder.sslProvider(SslProvider.valueOf((String)PROTOCOL_PROVIDER));
                    continue block6;
                }
                case SESSION_CACHE_SIZE: {
                    sslContextBuilder.sessionCacheSize(SESSION_CACHE_SIZE);
                    continue block6;
                }
                case SESSION_TIMEOUT: {
                    sslContextBuilder.sessionTimeout(SESSION_TIMEOUT);
                    continue block6;
                }
                case START_TLS: {
                    sslContextBuilder.startTls(START_TLS);
                    continue block6;
                }
            }
            GrpcLogger.LOGGER.unknownAttribute(attr.toString());
        }
        sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder);
        return sslContextBuilder.build();
    }

    static {
        monitor = new Object();
        restart = true;
        sslUpdates = new HashSet<SSL_ATTRIBUTE>();
        serverUpdates = new HashSet<SERVER_ATTRIBUTE>();
    }

    static enum SERVER_ATTRIBUTE {
        FLOW_CONTROL_WINDOW,
        HANDSHAKE_TIMEOUT,
        INITIAL_FLOW_CONTROL_WINDOW,
        KEEP_ALIVE_TIME,
        KEEP_ALIVE_TIMEOUT,
        KEY_MANAGER_NAME,
        MAX_CONCURRENT_CALLS_PER_CONNECTION,
        MAX_CONNECTION_AGE,
        MAX_CONNECTION_AGE_GRACE,
        MAX_CONNECTION_IDLE,
        MAX_INBOUND_MESSAGE_SIZE,
        MAX_INBOUND_METADATA_SIZE,
        PERMIT_KEEP_ALIVE_TIME,
        PERMIT_KEEP_ALIVE_WITHOUT_CALLS,
        SERVER_HOST,
        SERVER_PORT,
        SHUTDOWN_TIMEOUT,
        TRUST_MANAGER_NAME;

    }

    static enum SSL_ATTRIBUTE {
        PROTOCOL_PROVIDER,
        SESSION_CACHE_SIZE,
        SESSION_TIMEOUT,
        START_TLS;

    }
}

