/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc.deployment;

import io.grpc.BindableService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.grpc.GrpcServerService;

public class GrpcDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final DotName BINDABLE_CLASS = DotName.createSimple((String)BindableService.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) {
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List<String> serviceClasses = index.getAllKnownImplementors(BINDABLE_CLASS).stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        List<Class<?>> leaves = this.getLeaves(serviceClasses, (ClassLoader)module.getClassLoader());
        this.processManagement(deploymentUnit, leaves);
        try {
            GrpcServerService.install(serviceTarget, deploymentUnit, this.getLeaves(serviceClasses, (ClassLoader)module.getClassLoader()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Class<?>> getLeaves(List<String> classNames, ClassLoader classLoader) {
        ArrayList classes = new ArrayList();
        try {
            for (String s : classNames) {
                classes.add(classLoader.loadClass(s));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ArrayList leaves = new ArrayList();
        for (Class clazz : classes) {
            if (!this.isLeaf(clazz, classes)) continue;
            leaves.add(clazz);
        }
        return leaves;
    }

    private boolean isLeaf(Class<?> clazz, List<Class<?>> classes) {
        for (Class<?> c : classes) {
            if (clazz == c || !clazz.isAssignableFrom(c)) continue;
            return false;
        }
        return true;
    }

    private void processManagement(DeploymentUnit deploymentUnit, List<Class<?>> grpcServiceClasses) {
        DeploymentResourceSupport drs = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (Class<?> clazz : grpcServiceClasses) {
            ModelNode serviceModel = drs.getDeploymentSubModel("grpc", PathElement.pathElement((String)"grpc-service", (String)clazz.getSimpleName()));
            serviceModel.get("service-class").set(clazz.getName());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

