/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc;

import io.grpc.ServerInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InterceptorQueue
extends PriorityQueue<Element> {
    private static final long serialVersionUID = 1L;

    public InterceptorQueue() {
        this(new InterceptorComparator());
    }

    public InterceptorQueue(InterceptorComparator comp) {
        super(comp);
    }

    public void add(Class<? extends ServerInterceptor> clazz) {
        Element element = new Element();
        element.setPriority(this.getPriority(clazz));
        element.setClazz(clazz);
        this.add(element);
    }

    public List<Class<? extends ServerInterceptor>> toList() {
        ArrayList<Class<? extends ServerInterceptor>> list = new ArrayList<Class<? extends ServerInterceptor>>();
        while (this.peek() != null) {
            list.add(((Element)this.poll()).getClazz());
        }
        return list;
    }

    private Integer getPriority(Class<? extends ServerInterceptor> clazz) {
        try {
            for (Annotation an : clazz.getDeclaredAnnotations()) {
                if (!"jakarta.annotation.Priority".equals(an.annotationType().getName())) continue;
                Method value = an.annotationType().getMethod("value", new Class[0]);
                value.setAccessible(true);
                Integer i = (Integer)value.invoke((Object)an, new Object[0]);
                return i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 0x7FFFFFFE;
    }

    public static class InterceptorComparator
    implements Comparator<Element> {
        @Override
        public int compare(Element arg0, Element arg1) {
            if (arg0.priority > arg1.priority) {
                return -1;
            }
            if (arg0.priority == arg1.priority) {
                return 0;
            }
            return 1;
        }
    }

    public static class Element {
        public int priority;
        public Class<? extends ServerInterceptor> clazz;

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public Class<? extends ServerInterceptor> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<? extends ServerInterceptor> clazz) {
            this.clazz = clazz;
        }
    }
}

