/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc;

import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jboss.as.network.SocketBinding;
import org.wildfly.extension.grpc._private.GrpcLogger;

class ServerConfiguration {
    private volatile boolean built = false;
    private Supplier<SocketBinding> socketBinding;
    private Supplier<TrustManager> trustManager;
    private Supplier<KeyManager> keyManager;
    private Supplier<SSLContext> sslContext;
    private long shutdownTimeout;
    private String protocolProvider;
    private Long sessionCacheSize;
    private Long sessionTimeout;
    private boolean startTls;
    private int flowControlWindow;
    private int handshakeTimeout;
    private int initialFlowControlWindow;
    private long keepLiveTime;
    private long keepAliveTimeout;
    private int maxConccurentCallsPerConnection;
    private long maxConnectionAge;
    private long maxConnectionAgeGrace;
    private long maxConnectionIdle;
    private int maxInboundMessageSize;
    private int maxInboundMetadataSize;
    private long permitKeepAliveTime;
    private boolean permitKeepAliveWithoutCalls;

    ServerConfiguration(Supplier<SocketBinding> socketBinding) {
        this.socketBinding = socketBinding;
    }

    int getServerPort() {
        return this.socketBinding.get().getAbsolutePort();
    }

    String getHostName() {
        return this.socketBinding.get().getAddress().getHostName();
    }

    Supplier<TrustManager> getTrustManager() {
        return this.trustManager;
    }

    ServerConfiguration setTrustManager(Supplier<TrustManager> trustManager) {
        this.assertNotBuilt();
        this.trustManager = trustManager;
        return this;
    }

    Supplier<KeyManager> getKeyManager() {
        return this.keyManager;
    }

    ServerConfiguration setKeyManager(Supplier<KeyManager> keyManager) {
        this.assertNotBuilt();
        this.keyManager = keyManager;
        return this;
    }

    Supplier<SSLContext> getSslContext() {
        return this.sslContext;
    }

    ServerConfiguration setSslContext(Supplier<SSLContext> sslContext) {
        this.assertNotBuilt();
        this.sslContext = sslContext;
        return this;
    }

    long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    ServerConfiguration setShutdownTimeout(long shutdownTimeout) {
        this.assertNotBuilt();
        this.shutdownTimeout = shutdownTimeout;
        return this;
    }

    String getProtocolProvider() {
        return this.protocolProvider;
    }

    ServerConfiguration setProtocolProvider(String protocolProvider) {
        this.assertNotBuilt();
        this.protocolProvider = protocolProvider;
        return this;
    }

    Long getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    ServerConfiguration setSessionCacheSize(Long sessionCacheSize) {
        this.assertNotBuilt();
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    ServerConfiguration setSessionTimeout(Long sessionTimeout) {
        this.assertNotBuilt();
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    boolean isStartTls() {
        return this.startTls;
    }

    ServerConfiguration setStartTls(boolean startTls) {
        this.assertNotBuilt();
        this.startTls = startTls;
        return this;
    }

    ServerConfiguration setFlowControlWindow(int flowControlWindow) {
        this.assertNotBuilt();
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    ServerConfiguration setHandshakeTimeout(int handshakeTimeout) {
        this.assertNotBuilt();
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    int getHandshakeTimeout() {
        return this.handshakeTimeout;
    }

    ServerConfiguration setInitialFlowControlWindow(int initialFlowControlWindow) {
        this.assertNotBuilt();
        this.initialFlowControlWindow = initialFlowControlWindow;
        return this;
    }

    int getInitialFlowControlWindow() {
        return this.initialFlowControlWindow;
    }

    ServerConfiguration setKeepLiveTime(long keepLiveTime) {
        this.assertNotBuilt();
        this.keepLiveTime = keepLiveTime;
        return this;
    }

    long getKeepLiveTime() {
        return this.keepLiveTime;
    }

    ServerConfiguration setKeepAliveTimeout(long keepAliveTimeout) {
        this.assertNotBuilt();
        this.keepAliveTimeout = keepAliveTimeout;
        return this;
    }

    long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    ServerConfiguration setMaxConcurrentCallsPerConnection(int maxConccurentCallsPerConnection) {
        this.assertNotBuilt();
        this.maxConccurentCallsPerConnection = maxConccurentCallsPerConnection;
        return this;
    }

    int getMaxConcurrentCallsPerConnection() {
        return this.maxConccurentCallsPerConnection;
    }

    ServerConfiguration setMaxConnectionAge(long maxConnectionAge) {
        this.assertNotBuilt();
        this.maxConnectionAge = maxConnectionAge;
        return this;
    }

    long getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    ServerConfiguration setMaxConnectionAgeGrace(long maxConnectionAgeGrace) {
        this.assertNotBuilt();
        this.maxConnectionAgeGrace = maxConnectionAgeGrace;
        return this;
    }

    long getMaxConnectionAgeGrace() {
        return this.maxConnectionAgeGrace;
    }

    ServerConfiguration setMaxConnectionIdle(long maxConnectionIdle) {
        this.assertNotBuilt();
        this.maxConnectionIdle = maxConnectionIdle;
        return this;
    }

    long getMaxConnectionIdle() {
        return this.maxConnectionIdle;
    }

    ServerConfiguration setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.assertNotBuilt();
        this.maxInboundMessageSize = maxInboundMessageSize;
        return this;
    }

    int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    ServerConfiguration setMaxInboundMetadataSize(int maxInboundMetadataSize) {
        this.assertNotBuilt();
        this.maxInboundMetadataSize = maxInboundMetadataSize;
        return this;
    }

    int getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    ServerConfiguration setPermitKeepAliveTime(long permitKeepAliveTime) {
        this.assertNotBuilt();
        this.permitKeepAliveTime = permitKeepAliveTime;
        return this;
    }

    long getPermitKeepAliveTime() {
        return this.permitKeepAliveTime;
    }

    ServerConfiguration setPermitKeepAliveWithoutCalls(boolean permitKeepAliveWithoutCalls) {
        this.assertNotBuilt();
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
        return this;
    }

    boolean isPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    ServerConfiguration build() {
        this.built = true;
        return this;
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw GrpcLogger.LOGGER.configurationAlreadyBuilt();
        }
    }
}

