/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc.deployment;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.wildfly.extension.grpc.InterceptorQueue;
import org.wildfly.extension.grpc.WildFlyGrpcDeploymentRegistry;
import org.wildfly.extension.grpc._private.GrpcLogger;

public class GrpcDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName BINDABLE_CLASS = DotName.createSimple((String)BindableService.class.getName());
    private static final DotName SERVER_INTERCEPTOR_CLASS = DotName.createSimple((String)ServerInterceptor.class.getName());
    private final WildFlyGrpcDeploymentRegistry registry;

    public GrpcDeploymentProcessor(WildFlyGrpcDeploymentRegistry registry) {
        this.registry = registry;
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List<String> serviceClasses = index.getAllKnownImplementors(BINDABLE_CLASS).stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        List<Class<? extends BindableService>> leaves = this.getLeaves(serviceClasses, (ClassLoader)module.getClassLoader());
        this.processManagement(deploymentUnit, leaves);
        List<String> interceptorClasses = index.getAllKnownImplementors(SERVER_INTERCEPTOR_CLASS).stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        for (Class<? extends BindableService> type : this.getLeaves(serviceClasses, (ClassLoader)module.getClassLoader())) {
            this.registry.addService(deploymentUnit, type, this.getInterceptors(interceptorClasses, (ClassLoader)module.getClassLoader()));
        }
    }

    public void undeploy(DeploymentUnit context) {
        this.registry.removeDeploymentServices(context);
    }

    private List<Class<? extends BindableService>> getLeaves(List<String> classNames, ClassLoader classLoader) {
        ArrayList<Class<? extends BindableService>> classes = new ArrayList<Class<? extends BindableService>>();
        try {
            for (String s : classNames) {
                classes.add(classLoader.loadClass(s).asSubclass(BindableService.class));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Class<? extends BindableService>> leaves = new ArrayList<Class<? extends BindableService>>();
        for (Class clazz : classes) {
            if (!this.isLeaf(clazz, classes)) continue;
            leaves.add(clazz);
        }
        return leaves;
    }

    private boolean isLeaf(Class<?> clazz, List<Class<? extends BindableService>> classes) {
        for (Class<? extends BindableService> c : classes) {
            if (clazz == c || !clazz.isAssignableFrom(c)) continue;
            return false;
        }
        return true;
    }

    private List<Class<? extends ServerInterceptor>> getInterceptorClasses(List<String> classNames, ClassLoader classLoader) {
        InterceptorQueue classes = new InterceptorQueue();
        try {
            for (String s : classNames) {
                Class<ServerInterceptor> clazz = classLoader.loadClass(s).asSubclass(ServerInterceptor.class);
                classes.add(clazz);
            }
            return classes.toList();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private List<ServerInterceptor> getInterceptors(List<String> classNames, ClassLoader classLoader) {
        List<Class<? extends ServerInterceptor>> classes = this.getInterceptorClasses(classNames, classLoader);
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        for (int i = 0; i < classes.size(); ++i) {
            ServerInterceptor serverInterceptor;
            Class<? extends ServerInterceptor> interceptorType = classes.get(i);
            GrpcLogger.LOGGER.registerServerInterceptor(interceptorType.getName());
            if (System.getSecurityManager() == null) {
                try {
                    Constructor<? extends ServerInterceptor> constructor = interceptorType.getConstructor(new Class[0]);
                    serverInterceptor = constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw GrpcLogger.LOGGER.failedToRegister(e, interceptorType.getName());
                }
            } else {
                serverInterceptor = AccessController.doPrivileged(() -> {
                    try {
                        Constructor constructor = interceptorType.getConstructor(new Class[0]);
                        return (ServerInterceptor)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw GrpcLogger.LOGGER.failedToRegister(e, interceptorType.getName());
                    }
                });
            }
            interceptors.add(serverInterceptor);
        }
        return interceptors;
    }

    private void processManagement(DeploymentUnit deploymentUnit, List<Class<? extends BindableService>> grpcServiceClasses) {
        DeploymentResourceSupport drs = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (Class<? extends BindableService> clazz : grpcServiceClasses) {
            ModelNode serviceModel = drs.getDeploymentSubModel("grpc", PathElement.pathElement((String)"grpc-service", (String)clazz.getSimpleName()));
            serviceModel.get("service-class").set(clazz.getName());
        }
    }
}

