/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc._private;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.extension.grpc._private.GrpcLogger;

public class GrpcLogger_$logger
extends DelegatingBasicLogger
implements GrpcLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = GrpcLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public GrpcLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serverListening(String address, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverListening$str(), (Object)address, (Object)port);
    }

    protected String serverListening$str() {
        return "WFLYGRPC0001: gRPC server listening on %s:%d";
    }

    @Override
    public final void grpcStopping() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.grpcStopping$str(), new Object[0]);
    }

    protected String grpcStopping$str() {
        return "WFLYGRPC0002: gRPC service stopping";
    }

    @Override
    public final void failedToStopGrpcServer(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToStopGrpcServer$str(), new Object[0]);
    }

    protected String failedToStopGrpcServer$str() {
        return "WFLYGRPC0003: Failed to stop gRPC server";
    }

    protected String failedToRegister1$str() {
        return "WFLYGRPC0004: Failed to register %s";
    }

    @Override
    public final RuntimeException failedToRegister(Throwable cause, String serviceName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToRegister1$str(), serviceName), cause);
        GrpcLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String failedToRegister2$str() {
        return "WFLYGRPC0005: Failed to register %s for deployment %s";
    }

    @Override
    public final RuntimeException failedToRegister(Throwable cause, String serviceName, String deployment) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.failedToRegister2$str(), serviceName, deployment), cause);
        GrpcLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void registerService(String serviceName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.registerService$str(), (Object)serviceName, (Object)deploymentName);
    }

    protected String registerService$str() {
        return "WFLYGRPC0006: Registering gRPC service %s for deployment %s.";
    }

    @Override
    public final void registerServerInterceptor(String interceptorName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.registerServerInterceptor1$str(), (Object)interceptorName);
    }

    protected String registerServerInterceptor1$str() {
        return "WFLYGRPC0007: Registering global gRPC ServerInterceptor %s.";
    }

    @Override
    public final void registerServerInterceptor(String interceptorName, String deploymentName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.registerServerInterceptor2$str(), (Object)interceptorName, (Object)deploymentName);
    }

    protected String registerServerInterceptor2$str() {
        return "WFLYGRPC0008: Registering gRPC ServerInterceptor %s for deployment %s.";
    }

    @Override
    public final void methodNotImplemented(String methodName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.methodNotImplemented$str(), (Object)methodName);
    }

    protected String methodNotImplemented$str() {
        return "WFLYGRPC0009: Method %s is not implemented.";
    }

    protected String configurationAlreadyBuilt$str() {
        return "WFLYGRPC0010: The configuration object has already been built.";
    }

    @Override
    public final IllegalStateException configurationAlreadyBuilt() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.configurationAlreadyBuilt$str(), new Object[0]));
        GrpcLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

