/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.grpc.ServerConfiguration;
import org.wildfly.extension.grpc.WildFlyGrpcDeploymentRegistry;
import org.wildfly.extension.grpc._private.GrpcLogger;

class GrpcServerService
implements Service,
WildFlyGrpcDeploymentRegistry {
    private final Consumer<GrpcServerService> serverService;
    private final Supplier<ExecutorService> executorService;
    private final MutableHandlerRegistry registry;
    private final NettyServerBuilder serverBuilder;
    private final ServerConfiguration configuration;
    private final Map<String, Collection<ServerServiceDefinition>> deploymentServices;
    private volatile Server server;

    GrpcServerService(NettyServerBuilder serverBuilder, MutableHandlerRegistry registry, Consumer<GrpcServerService> serverService, Supplier<ExecutorService> executorService, ServerConfiguration configuration) {
        this.serverBuilder = serverBuilder;
        this.registry = registry;
        this.serverService = serverService;
        this.executorService = executorService;
        this.configuration = configuration;
        this.deploymentServices = new ConcurrentHashMap<String, Collection<ServerServiceDefinition>>();
    }

    public void start(StartContext context) {
        context.asynchronous();
        this.executorService.get().submit(() -> {
            try {
                if (this.configuration.getKeyManager() != null) {
                    SSLContext sslContext = this.configuration.getSslContext() == null ? null : this.configuration.getSslContext().get();
                    this.serverBuilder.sslContext(this.createSslContext(sslContext));
                }
                this.server = this.serverBuilder.build().start();
                GrpcLogger.LOGGER.serverListening(this.configuration.getHostName(), this.server.getPort());
                this.serverService.accept(this);
                context.complete();
            }
            catch (Throwable e) {
                context.failed(new StartException(e));
            }
        });
    }

    public void stop(StopContext context) {
        GrpcLogger.LOGGER.grpcStopping();
        Server server = this.server;
        if (server != null) {
            try {
                server.shutdown().awaitTermination(this.configuration.getShutdownTimeout(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                GrpcLogger.LOGGER.failedToStopGrpcServer(e);
            }
        }
        this.serverService.accept(null);
    }

    @Override
    public void addService(DeploymentUnit deployment, Class<? extends BindableService> serviceType) {
        BindableService bindableService;
        String deploymentName = deployment.getName();
        GrpcLogger.LOGGER.registerService(serviceType.getName(), deploymentName);
        if (System.getSecurityManager() == null) {
            try {
                Constructor<? extends BindableService> constructor = serviceType.getConstructor(new Class[0]);
                bindableService = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw GrpcLogger.LOGGER.failedToRegisterService(e, serviceType.getName(), deploymentName);
            }
        } else {
            bindableService = AccessController.doPrivileged(() -> {
                try {
                    Constructor constructor = serviceType.getConstructor(new Class[0]);
                    return (BindableService)constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw GrpcLogger.LOGGER.failedToRegisterService(e, serviceType.getName(), deploymentName);
                }
            });
        }
        Collection defs = this.deploymentServices.computeIfAbsent(deploymentName, c -> new ArrayList());
        defs.add(this.registry.addService(bindableService));
    }

    @Override
    public void removeDeploymentServices(DeploymentUnit deployment) {
        Collection<ServerServiceDefinition> defs = this.deploymentServices.remove(deployment.getName());
        if (defs != null) {
            for (ServerServiceDefinition def : defs) {
                this.registry.removeService(def);
            }
        }
    }

    private SslContext createSslContext(SSLContext sslContext) throws SSLException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManager)this.configuration.getKeyManager().get());
        if (sslContext != null) {
            sslContextBuilder.sslContextProvider(sslContext.getProvider());
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslContextBuilder.ciphers(Arrays.asList(sslEngine.getEnabledCipherSuites()));
            sslContextBuilder.protocols(sslContext.getDefaultSSLParameters().getApplicationProtocols());
            if (this.configuration.getTrustManager() != null) {
                sslContextBuilder.trustManager(this.configuration.getTrustManager().get());
            }
        }
        if (this.configuration.getProtocolProvider() != null) {
            sslContextBuilder.sslProvider(SslProvider.valueOf((String)this.configuration.getProtocolProvider()));
        }
        if (this.configuration.getSessionCacheSize() != null) {
            sslContextBuilder.sessionCacheSize(this.configuration.getSessionCacheSize().longValue());
        }
        if (this.configuration.getSessionTimeout() != null) {
            sslContextBuilder.sessionTimeout(this.configuration.getSessionTimeout().longValue());
        }
        sslContextBuilder.startTls(this.configuration.isStartTls());
        return GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder).build();
    }
}

