/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc;

import io.grpc.HandlerRegistry;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.grpc.GrpcServerService;
import org.wildfly.extension.grpc.GrpcSubsystemDefinition;
import org.wildfly.extension.grpc.ServerConfiguration;
import org.wildfly.extension.grpc.deployment.GrpcDependencyProcessor;
import org.wildfly.extension.grpc.deployment.GrpcDeploymentProcessor;

class GrpcSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static GrpcSubsystemAdd INSTANCE = new GrpcSubsystemAdd();

    public GrpcSubsystemAdd() {
        super(GrpcSubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name;
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
        String serverHost = GrpcSubsystemDefinition.GRPC_SERVER_HOST.resolveModelAttribute(context, model).asString();
        MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
        int serverPort = GrpcSubsystemDefinition.GRPC_SERVER_PORT.resolveModelAttribute(context, model).asInt();
        NettyServerBuilder serverBuilder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(serverHost, serverPort));
        serverBuilder.fallbackHandlerRegistry((HandlerRegistry)handlerRegistry);
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_FLOW_CONTROL_WINDOW, model)) {
            serverBuilder.flowControlWindow(GrpcSubsystemDefinition.GRPC_FLOW_CONTROL_WINDOW.resolveModelAttribute(context, model).asInt());
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_HANDSHAKE_TIMEOUT, model)) {
            serverBuilder.handshakeTimeout((long)GrpcSubsystemDefinition.GRPC_HANDSHAKE_TIMEOUT.resolveModelAttribute(context, model).asInt(), TimeUnit.SECONDS);
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_INITIAL_FLOW_CONTROL_WINDOW, model)) {
            serverBuilder.initialFlowControlWindow(GrpcSubsystemDefinition.GRPC_INITIAL_FLOW_CONTROL_WINDOW.resolveModelAttribute(context, model).asInt());
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_KEEP_ALIVE_TIME, model)) {
            serverBuilder.keepAliveTime(GrpcSubsystemDefinition.GRPC_KEEP_ALIVE_TIME.resolveModelAttribute(context, model).asLong(), TimeUnit.SECONDS);
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_KEEP_ALIVE_TIMEOUT, model)) {
            serverBuilder.keepAliveTimeout(GrpcSubsystemDefinition.GRPC_KEEP_ALIVE_TIMEOUT.resolveModelAttribute(context, model).asLong(), TimeUnit.SECONDS);
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_MAX_CONCURRENT_CALLS_PER_CONNECTION, model)) {
            serverBuilder.maxConcurrentCallsPerConnection(GrpcSubsystemDefinition.GRPC_MAX_CONCURRENT_CALLS_PER_CONNECTION.resolveModelAttribute(context, model).asInt());
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_AGE, model)) {
            serverBuilder.maxConnectionAge(GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_AGE.resolveModelAttribute(context, model).asLong(), TimeUnit.SECONDS);
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_AGE_GRACE, model)) {
            serverBuilder.maxConnectionAgeGrace(GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_AGE_GRACE.resolveModelAttribute(context, model).asLong(), TimeUnit.SECONDS);
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_IDLE, model)) {
            serverBuilder.maxConnectionIdle(GrpcSubsystemDefinition.GRPC_MAX_CONNECTION_IDLE.resolveModelAttribute(context, model).asLong(), TimeUnit.SECONDS);
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_MAX_INBOUND_MESSAGE_SIZE, model)) {
            serverBuilder.maxInboundMessageSize(GrpcSubsystemDefinition.GRPC_MAX_INBOUND_MESSAGE_SIZE.resolveModelAttribute(context, model).asInt());
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_MAX_INBOUND_METADATA_SIZE, model)) {
            serverBuilder.maxInboundMetadataSize(GrpcSubsystemDefinition.GRPC_MAX_INBOUND_METADATA_SIZE.resolveModelAttribute(context, model).asInt());
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_PERMIT_KEEP_ALIVE_TIME, model)) {
            serverBuilder.permitKeepAliveTime(GrpcSubsystemDefinition.GRPC_PERMIT_KEEP_ALIVE_TIME.resolveModelAttribute(context, model).asLong(), TimeUnit.SECONDS);
        }
        serverBuilder.permitKeepAliveWithoutCalls(GrpcSubsystemDefinition.GRPC_PERMIT_KEEP_ALIVE_WITHOUT_CALLS.resolveModelAttribute(context, model).asBoolean());
        CapabilityServiceTarget target = context.getCapabilityServiceTarget();
        CapabilityServiceBuilder builder = target.addCapability(GrpcSubsystemDefinition.SERVER_CAPABILITY);
        ServerConfiguration configuration = new ServerConfiguration(serverHost);
        configuration.setProtocolProvider(GrpcSubsystemDefinition.GRPC_PROTOCOL_PROVIDER.resolveModelAttribute(context, model).asStringOrNull()).setSessionCacheSize(GrpcSubsystemDefinition.GRPC_SESSION_CACHE_SIZE.resolveModelAttribute(context, model).asLongOrNull()).setSessionTimeout(GrpcSubsystemDefinition.GRPC_SESSION_TIMEOUT.resolveModelAttribute(context, model).asLongOrNull()).setShutdownTimeout(GrpcSubsystemDefinition.GRPC_SHUTDOWN_TIMEOUT.resolveModelAttribute(context, model).asInt()).setStartTls(GrpcSubsystemDefinition.GRPC_START_TLS.resolveModelAttribute(context, model).asBoolean());
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_TRUST_MANAGER_NAME, model)) {
            configuration.setTrustManager(builder.requiresCapability("org.wildfly.security.trust-manager", TrustManager.class, new String[]{GrpcSubsystemDefinition.GRPC_TRUST_MANAGER_NAME.resolveModelAttribute(context, model).asString()}));
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_KEY_MANAGER_NAME, model) && !(name = GrpcSubsystemDefinition.GRPC_KEY_MANAGER_NAME.resolveModelAttribute(context, model).asString()).isBlank()) {
            configuration.setKeyManager(builder.requiresCapability("org.wildfly.security.key-manager", KeyManager.class, new String[]{name}));
        }
        if (GrpcSubsystemAdd.isDefined((AttributeDefinition)GrpcSubsystemDefinition.GRPC_SSL_CONTEXT_NAME, model)) {
            configuration.setSslContext(builder.requiresCapability("org.wildfly.security.ssl-context", SSLContext.class, new String[]{GrpcSubsystemDefinition.GRPC_SSL_CONTEXT_NAME.resolveModelAttribute(context, model).asString()}));
        }
        Consumer provides = builder.provides(GrpcSubsystemDefinition.SERVER_CAPABILITY);
        final GrpcServerService service = new GrpcServerService(serverBuilder, handlerRegistry, provides, Services.requireServerExecutor((ServiceBuilder)builder), configuration);
        builder.setInstance((Service)service).install();
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                int DEPENDENCIES_PRIORITY = 6304;
                processorTarget.addDeploymentProcessor("grpc", Phase.DEPENDENCIES, DEPENDENCIES_PRIORITY, (DeploymentUnitProcessor)new GrpcDependencyProcessor());
                int DEPLOYMENT_PRIORITY = 6305;
                processorTarget.addDeploymentProcessor("grpc", Phase.POST_MODULE, DEPLOYMENT_PRIORITY, (DeploymentUnitProcessor)new GrpcDeploymentProcessor(service));
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private static boolean isDefined(AttributeDefinition def, ModelNode model) {
        return model.hasDefined(def.getName());
    }
}

