/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.grpc.deployment;

import io.grpc.BindableService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.wildfly.extension.grpc.WildFlyGrpcDeploymentRegistry;

public class GrpcDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName BINDABLE_CLASS = DotName.createSimple((String)BindableService.class.getName());
    private final WildFlyGrpcDeploymentRegistry registry;

    public GrpcDeploymentProcessor(WildFlyGrpcDeploymentRegistry registry) {
        this.registry = registry;
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List<String> serviceClasses = index.getAllKnownImplementors(BINDABLE_CLASS).stream().map(ci -> ci.name().toString()).collect(Collectors.toList());
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        List<Class<? extends BindableService>> leaves = this.getLeaves(serviceClasses, (ClassLoader)module.getClassLoader());
        this.processManagement(deploymentUnit, leaves);
        for (Class<? extends BindableService> type : this.getLeaves(serviceClasses, (ClassLoader)module.getClassLoader())) {
            this.registry.addService(deploymentUnit, type);
        }
    }

    public void undeploy(DeploymentUnit context) {
        this.registry.removeDeploymentServices(context);
    }

    private List<Class<? extends BindableService>> getLeaves(List<String> classNames, ClassLoader classLoader) {
        ArrayList<Class<? extends BindableService>> classes = new ArrayList<Class<? extends BindableService>>();
        try {
            for (String s : classNames) {
                classes.add(classLoader.loadClass(s).asSubclass(BindableService.class));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Class<? extends BindableService>> leaves = new ArrayList<Class<? extends BindableService>>();
        for (Class clazz : classes) {
            if (!this.isLeaf(clazz, classes)) continue;
            leaves.add(clazz);
        }
        return leaves;
    }

    private boolean isLeaf(Class<?> clazz, List<Class<? extends BindableService>> classes) {
        for (Class<? extends BindableService> c : classes) {
            if (clazz == c || !clazz.isAssignableFrom(c)) continue;
            return false;
        }
        return true;
    }

    private void processManagement(DeploymentUnit deploymentUnit, List<Class<? extends BindableService>> grpcServiceClasses) {
        DeploymentResourceSupport drs = (DeploymentResourceSupport)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT);
        for (Class<? extends BindableService> clazz : grpcServiceClasses) {
            ModelNode serviceModel = drs.getDeploymentSubModel("grpc", PathElement.pathElement((String)"grpc-service", (String)clazz.getSimpleName()));
            serviceModel.get("service-class").set(clazz.getName());
        }
    }
}

