/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public final class PatchSet {
    private final PatchId patchId;
    private final Map<Path, Record> recordsMap = new LinkedHashMap<Path, Record>();
    private final List<String> commands = new ArrayList<String>();
    private final Set<PatchId> dependencies = new LinkedHashSet<PatchId>();
    private int hashCache;

    public static PatchSet create(PatchId patchId, Collection<Record> records) {
        return new PatchSet(patchId, records, Collections.emptySet(), Collections.emptyList());
    }

    public static PatchSet create(PatchId patchId, Collection<Record> records, Set<PatchId> dependencies) {
        return new PatchSet(patchId, records, dependencies, Collections.emptyList());
    }

    public static PatchSet create(PatchId patchId, Collection<Record> records, List<String> commands) {
        return new PatchSet(patchId, records, Collections.emptySet(), commands);
    }

    public static PatchSet create(PatchId patchId, Collection<Record> records, Set<PatchId> dependencies, List<String> commands) {
        return new PatchSet(patchId, records, dependencies, commands);
    }

    public static PatchSet smartSet(PatchSet seedPatch, PatchSet targetSet) {
        IllegalArgumentAssertion.assertNotNull(targetSet, "targetSet");
        HashMap<Path, Record> removeMap = new HashMap<Path, Record>();
        if (seedPatch != null) {
            for (Record rec : seedPatch.getRecords()) {
                removeMap.put(rec.getPath(), Record.create(Action.DEL, rec.getPath(), rec.getChecksum()));
            }
        }
        HashSet<Record> records = new HashSet<Record>();
        for (Record rec : targetSet.getRecords()) {
            Path path = rec.getPath();
            Long checksum = rec.getChecksum();
            if (removeMap.containsValue(rec)) {
                removeMap.remove(path);
                continue;
            }
            if (removeMap.containsKey(path)) {
                removeMap.remove(path);
                records.add(Record.create(Action.UPD, path, checksum));
                continue;
            }
            records.add(Record.create(Action.ADD, path, checksum));
        }
        records.addAll(removeMap.values());
        return new PatchSet(targetSet.patchId, records, targetSet.dependencies, targetSet.commands);
    }

    private PatchSet(PatchId patchId, Collection<Record> records, Set<PatchId> dependencies, List<String> commands) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        IllegalArgumentAssertion.assertNotNull(records, "records");
        IllegalArgumentAssertion.assertNotNull(dependencies, "dependencies");
        IllegalArgumentAssertion.assertNotNull(commands, "commands");
        this.dependencies.addAll(dependencies);
        this.commands.addAll(commands);
        this.patchId = patchId;
        HashMap<Path, Record> auxmap = new HashMap<Path, Record>();
        for (Record rec : records) {
            auxmap.put(rec.getPath(), rec);
        }
        ArrayList paths = new ArrayList(auxmap.keySet());
        Collections.sort(paths);
        for (Path path : paths) {
            this.recordsMap.put(path, (Record)auxmap.get(path));
        }
    }

    public PatchId getPatchId() {
        return this.patchId;
    }

    public List<Record> getRecords() {
        return Collections.unmodifiableList(new ArrayList<Record>(this.recordsMap.values()));
    }

    public boolean containsPath(Path path) {
        return this.recordsMap.containsKey(path);
    }

    public Record getRecord(Path path) {
        return this.recordsMap.get(path);
    }

    public Set<PatchId> getDependencies() {
        return this.dependencies;
    }

    public List<String> getPostCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = ("" + this.patchId + this.recordsMap + this.commands).hashCode();
        }
        return this.hashCache;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatchSet)) {
            return false;
        }
        PatchSet other = (PatchSet)obj;
        boolean result = this.patchId.equals(other.patchId);
        result &= this.recordsMap.equals(other.recordsMap);
        result &= this.dependencies.equals(other.dependencies);
        return result &= this.commands.equals(other.commands);
    }

    public String toString() {
        return "PatchSet[" + this.patchId + ",recs=" + this.recordsMap.size() + ",deps=" + this.dependencies + ",cmds=" + this.commands.size() + "]";
    }

    public static final class Record {
        private final Action action;
        private final Path path;
        private final Long checksum;

        public static Record create(Path path) {
            return new Record(Action.INFO, path, 0L);
        }

        public static Record create(Path path, Long checksum) {
            return new Record(Action.INFO, path, checksum);
        }

        public static Record create(Action action, Path path, Long checksum) {
            return new Record(action, path, checksum);
        }

        public static Record fromString(String line) {
            IllegalArgumentAssertion.assertNotNull(line, "line");
            String[] toks = line.split("[\\s]");
            IllegalStateAssertion.assertEquals(3, toks.length, "Invalid line: " + line);
            return new Record(Action.valueOf(toks[0]), Paths.get(toks[1], new String[0]), new Long(toks[2]));
        }

        private Record(Action action, Path path, Long checksum) {
            IllegalArgumentAssertion.assertNotNull(action, "action");
            IllegalArgumentAssertion.assertNotNull(path, "path");
            IllegalArgumentAssertion.assertNotNull(checksum, "checksum");
            this.action = action;
            this.path = path;
            this.checksum = checksum;
        }

        public Action getAction() {
            return this.action;
        }

        public Path getPath() {
            return this.path;
        }

        public Long getChecksum() {
            return this.checksum;
        }

        public int hashCode() {
            return ("" + this.path + this.checksum).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Record)) {
                return false;
            }
            Record other = (Record)obj;
            return this.path.equals(other.path) && this.checksum.equals(other.checksum);
        }

        public String toString() {
            return (Object)((Object)this.action) + " " + this.path + " " + this.checksum;
        }
    }

    public static enum Action {
        INFO,
        ADD,
        UPD,
        DEL;

    }
}

