/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.internal.PatchLogger;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

final class DefaultPatchRepository
implements Repository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPatchRepository.class);
    private final Path rootPath;

    DefaultPatchRepository(URL repoUrl) {
        if (repoUrl == null) {
            repoUrl = DefaultPatchRepository.getConfiguredUrl();
        }
        IllegalStateAssertion.assertNotNull(repoUrl, "Cannot obtain repository URL");
        Path path = Paths.get(repoUrl.getPath(), new String[0]);
        PatchAssertion.assertTrue(path.toFile().isDirectory(), "Repository root does not exist: " + path);
        LOG.debug("Repository location: {}", (Object)path);
        this.rootPath = path.toAbsolutePath();
    }

    @Override
    public List<PatchId> queryAvailable(String prefix) {
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.rootPath, prefix, false);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId getLatestAvailable(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.rootPath, prefix, true);
            PatchId patchId = list.isEmpty() ? null : list.get(0);
            return patchId;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public Package getPackage(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            Package package_ = Parser.readPackage(this.rootPath, patchId);
            return package_;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public PatchId addArchive(URL fileUrl) throws IOException {
        return this.addArchive(fileUrl, null, Collections.emptySet(), false);
    }

    @Override
    public PatchId addArchive(URL fileUrl, PatchId oneoffId) throws IOException {
        return this.addArchive(fileUrl, oneoffId, Collections.emptySet(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public PatchId addArchive(URL fileUrl, PatchId oneoffId, Set<PatchId> dependencies, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(fileUrl, "fileUrl");
        IllegalArgumentAssertion.assertTrue(fileUrl.getPath().endsWith(".zip"), "Unsupported file extension: " + fileUrl);
        Lock.tryLock();
        try {
            void var11_21;
            Package patchSet;
            Path sourcePath = Paths.get(fileUrl.getPath(), new String[0]);
            PatchId patchId = PatchId.fromFile(sourcePath.toFile());
            PatchAssertion.assertFalse(this.queryAvailable(null).contains(patchId), "Repository already contains " + patchId);
            if (oneoffId != null) {
                File metadataFile = Parser.getMetadataFile(this.rootPath, oneoffId);
                PatchAssertion.assertTrue(metadataFile.isFile(), "Cannot obtain target patch for: " + oneoffId);
            }
            HashMap<Path, PatchId> pathMap = new HashMap<Path, PatchId>();
            for (PatchId auxid : Parser.getAvailable(this.rootPath, null, false)) {
                if (patchId.getName().equals(auxid.getName())) continue;
                for (Record record : this.getPackage(auxid).getRecords()) {
                    pathMap.put(record.getPath(), auxid);
                }
            }
            if (oneoffId != null) {
                Package oneoffSet = this.getPackage(oneoffId);
                HashMap<Path, Record> records = new HashMap<Path, Record>();
                for (Record record : oneoffSet.getRecords()) {
                    records.put(record.getPath(), record);
                }
                Package package_ = Parser.buildPackageFromZip(patchId, Record.Action.INFO, sourcePath.toFile());
                for (Record rec : package_.getRecords()) {
                    records.put(rec.getPath(), rec);
                }
                LinkedHashSet<PatchId> linkedHashSet = new LinkedHashSet<PatchId>(dependencies);
                linkedHashSet.add(oneoffId);
                patchSet = Package.create(patchId, records.values(), linkedHashSet);
            } else {
                Package sourceSet = Parser.buildPackageFromZip(patchId, Record.Action.INFO, sourcePath.toFile());
                patchSet = Package.create(patchId, sourceSet.getRecords(), dependencies);
            }
            HashSet<PatchId> duplicates = new HashSet<PatchId>();
            for (Record record : patchSet.getRecords()) {
                PatchId patchId2 = (PatchId)pathMap.get(record.getPath());
                if (patchId2 == null) continue;
                String message = "Path '" + record.getPath() + "' already contained in: " + patchId2;
                if (force) {
                    PatchLogger.warn(message);
                } else {
                    PatchLogger.error(message);
                }
                duplicates.add(patchId2);
            }
            PatchAssertion.assertTrue(force || duplicates.isEmpty(), "Cannot add " + patchId + " because of duplicate paths in " + duplicates);
            File targetFile = this.getPatchFile(patchId);
            targetFile.getParentFile().mkdirs();
            Files.copy(sourcePath, targetFile.toPath(), new CopyOption[0]);
            Parser.writePackage(this.rootPath, patchSet);
            if (sourcePath.startsWith(this.rootPath)) {
                sourcePath.toFile().delete();
            }
            String string = "Added " + patchId;
            if (oneoffId != null) {
                String string2 = string + " patching " + oneoffId;
            }
            if (!dependencies.isEmpty()) {
                void var11_19;
                String string3 = (String)var11_19 + " with dependencies on " + dependencies;
            }
            PatchLogger.info((String)var11_21);
            PatchId patchId3 = patchId;
            return patchId3;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPostCommand(PatchId patchId, String[] cmdarr) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        IllegalArgumentAssertion.assertNotNull(cmdarr, "cmdarr");
        Lock.tryLock();
        try {
            Package patchSet = this.getPackage(patchId);
            ArrayList<String> commands = new ArrayList<String>(patchSet.getPostCommands());
            commands.add(this.commandString(cmdarr));
            patchSet = Package.create(patchId, patchSet.getRecords(), commands);
            try {
                Parser.writePackage(this.rootPath, patchSet);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            PatchLogger.info("Added post install command to " + patchId);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmartPatch getSmartPatch(Package seedPatch, PatchId patchId) {
        Lock.tryLock();
        try {
            if (patchId == null) {
                IllegalArgumentAssertion.assertNotNull(seedPatch, "seedPatch");
                patchId = this.getLatestAvailable(seedPatch.getPatchId().getName());
            }
            File zipfile = this.getPatchFile(patchId);
            PatchAssertion.assertTrue(zipfile.isFile(), "Cannot obtain patch file: " + zipfile);
            Package targetSet = this.getPackage(patchId);
            Package smartSet = Package.smartSet(seedPatch, targetSet);
            SmartPatch smartPatch = new SmartPatch(smartSet, zipfile);
            return smartPatch;
        }
        finally {
            Lock.unlock();
        }
    }

    static URL getConfiguredUrl() {
        String repoSpec = System.getProperty("fusepatch.repository");
        if (repoSpec == null) {
            repoSpec = System.getenv("FUSEPATCH_REPOSITORY");
        }
        if (repoSpec != null) {
            try {
                return new URL(repoSpec);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return null;
    }

    private String commandString(String[] cmdarr) {
        StringBuffer result = new StringBuffer();
        for (String tok : cmdarr) {
            result.append(tok + " ");
        }
        return result.toString().trim();
    }

    private File getPatchFile(PatchId patchId) {
        return this.rootPath.resolve(Paths.get(patchId.getName(), patchId.getVersion().toString(), patchId + ".zip")).toFile();
    }
}

