/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.ServerInstance;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.internal.PatchLogger;
import org.wildfly.extras.patch.utils.IOUtils;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

final class WildFlyServerInstance
implements ServerInstance {
    private static final Logger LOG = LoggerFactory.getLogger(WildFlyServerInstance.class);
    private static final String FUSE_LAYER = "fuse";
    private final Path homePath;

    WildFlyServerInstance(Path homePath) {
        if (homePath == null) {
            homePath = WildFlyServerInstance.getConfiguredHomePath();
        }
        IllegalStateAssertion.assertNotNull(homePath, "Cannot obtain JBOSS_HOME");
        IllegalStateAssertion.assertTrue(homePath.toFile().isDirectory(), "Directory JBOSS_HOME does not exist: " + homePath);
        this.homePath = homePath.toAbsolutePath();
    }

    @Override
    public Path getDefaultRepositoryPath() {
        return this.homePath.resolve(Paths.get("fusepatch", "repository"));
    }

    @Override
    public Path getServerHome() {
        return this.homePath;
    }

    @Override
    public List<PatchId> queryAppliedPatches() {
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.getWorkspace(), null, true);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.getAvailable(this.getWorkspace(), prefix, true);
            Package package_ = list.isEmpty() ? null : this.getPackage(list.get(0));
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public List<String> getAuditLog() {
        Lock.tryLock();
        try {
            List<String> list = Parser.readAuditLog(this.getWorkspace());
            return list;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public Package getPackage(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            Package package_ = Parser.readPackage(this.getWorkspace(), patchId);
            return package_;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package applySmartPatch(SmartPatch smartPatch, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(smartPatch, "smartPatch");
        if (smartPatch.getRecords().isEmpty()) {
            PatchLogger.warn("Patch " + smartPatch.getPatchId() + " has already been applied");
            return null;
        }
        Lock.tryLock();
        try {
            PatchId serverId;
            Path path;
            List<PatchId> appliedPatches = this.queryAppliedPatches();
            ArrayList<PatchId> unsatisfied = new ArrayList<PatchId>();
            for (PatchId depId : smartPatch.getDependencies()) {
                if (appliedPatches.contains(depId)) continue;
                unsatisfied.add(depId);
            }
            PatchAssertion.assertTrue(unsatisfied.isEmpty(), "Unsatisfied dependencies: " + unsatisfied);
            PatchId patchId = smartPatch.getPatchId();
            Package serverSet = this.getPackage(patchId.getName());
            HashMap<Path, Record> serverRecords = new HashMap<Path, Record>();
            if (serverSet != null) {
                for (Record record : serverSet.getRecords()) {
                    serverRecords.put(record.getPath(), record);
                }
            }
            for (Record record : smartPatch.getRemoveSet()) {
                path = this.getServerHome().resolve(record.getPath());
                if (!path.toFile().exists()) {
                    PatchLogger.warn("Attempt to delete a non existing file " + record.getPath());
                }
                serverRecords.remove(record.getPath());
            }
            for (Record record : smartPatch.getReplaceSet()) {
                Long wasCheck;
                Record exprec;
                Long expcheck;
                path = this.getServerHome().resolve(record.getPath());
                String filename = path.getFileName().toString();
                if (!path.toFile().exists()) {
                    PatchLogger.warn("Attempt to replace a non existing file " + record.getPath());
                } else if ((filename.endsWith(".xml") || filename.endsWith(".properties")) && !(expcheck = Long.valueOf((exprec = (Record)serverRecords.get(record.getPath())) != null ? exprec.getChecksum() : 0L)).equals(wasCheck = Long.valueOf(IOUtils.getCRC32(path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to override an already modified file " + record.getPath());
                    PatchLogger.warn("Overriding an already modified file " + record.getPath());
                }
                serverRecords.put(record.getPath(), record);
            }
            for (Record record : smartPatch.getAddSet()) {
                Long wasCheck;
                Long expcheck;
                path = this.getServerHome().resolve(record.getPath());
                if (path.toFile().exists() && !(expcheck = record.getChecksum()).equals(wasCheck = Long.valueOf(IOUtils.getCRC32(path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to add an already existing file " + record.getPath());
                    PatchLogger.warn("Overriding an already existing file " + record.getPath());
                }
                serverRecords.put(record.getPath(), record);
            }
            this.updateServerFiles(smartPatch);
            HashSet<Record> inforecs = new HashSet<Record>();
            for (Record rec : serverRecords.values()) {
                inforecs.add(Record.create(rec.getPath(), rec.getChecksum()));
            }
            Package package_ = Package.create(patchId, inforecs);
            Parser.writePackage(this.getWorkspace(), package_);
            String message = serverSet == null ? "Installed " + patchId : ((serverId = serverSet.getPatchId()).compareTo(patchId) < 0 ? "Upgraded from " + serverId + " to " + patchId : (serverId.compareTo(patchId) == 0 ? "Reinstalled " + patchId : "Downgraded from " + serverId + " to " + patchId));
            PatchLogger.info(message);
            Parser.writeAuditLog(this.getWorkspace(), message, smartPatch);
            Runtime runtime = Runtime.getRuntime();
            File procdir = this.homePath.toFile();
            for (String cmd : smartPatch.getPostCommands()) {
                PatchLogger.info("Run: " + cmd);
                String[] envarr = new String[]{};
                String[] cmdarr = cmd.split("\\s");
                Process proc = runtime.exec(cmdarr, envarr, procdir);
                try {
                    this.startStreaming(proc.getInputStream(), System.out);
                    this.startStreaming(proc.getErrorStream(), System.err);
                    if (proc.waitFor() == 0) continue;
                    LOG.error("Command did not terminate normally: " + cmd);
                    break;
                }
                catch (InterruptedException ex) {
                }
            }
            Package package_2 = package_;
            return package_2;
        }
        finally {
            Lock.unlock();
        }
    }

    private Thread startStreaming(final InputStream input, final OutputStream output) {
        Thread thread = new Thread("io"){

            @Override
            public void run() {
                try {
                    IOUtils.copy(input, output);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    private void updateServerFiles(SmartPatch smartPatch) throws IOException {
        Object path;
        HashSet<Path> addupdPaths = new HashSet<Path>();
        for (Record rec2 : smartPatch.getAddSet()) {
            addupdPaths.add(rec2.getPath());
        }
        for (Record rec : smartPatch.getReplaceSet()) {
            addupdPaths.add(rec.getPath());
        }
        File patchFile = smartPatch.getPatchFile();
        Throwable throwable = null;
        try (Object zip = new ZipInputStream(new FileInputStream(patchFile));){
            ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    Path path2 = Paths.get(entry.getName(), new String[0]);
                    addupdPaths.remove(path2);
                }
                entry = ((ZipInputStream)zip).getNextEntry();
            }
        }
        catch (Throwable entry) {
            Throwable throwable2 = entry;
            throw entry;
        }
        IllegalStateAssertion.assertTrue(addupdPaths.isEmpty(), "Patch file does not contain expected paths: " + addupdPaths);
        for (Record record : smartPatch.getRemoveSet()) {
            Path path3 = this.getServerHome().resolve(record.getPath());
            Files.deleteIfExists(path3);
        }
        zip = new ZipInputStream(new FileInputStream(patchFile));
        Throwable throwable3 = null;
        try {
            byte[] buffer = new byte[1024];
            ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory() && (smartPatch.isReplacePath((Path)(path = Paths.get(entry.getName(), new String[0]))) || smartPatch.isAddPath((Path)path))) {
                    String[] file = this.homePath.resolve((Path)path).toFile();
                    file.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream((File)file);){
                        int read = ((FilterInputStream)zip).read(buffer);
                        while (read > 0) {
                            fos.write(buffer, 0, read);
                            read = ((FilterInputStream)zip).read(buffer);
                        }
                    }
                    if (file.getName().endsWith(".sh") || file.getName().endsWith(".bat")) {
                        file.setExecutable(true);
                    }
                }
                entry = ((ZipInputStream)zip).getNextEntry();
            }
        }
        catch (Throwable buffer) {
            Throwable throwable4 = buffer;
            throw buffer;
        }
        finally {
            if (zip != null) {
                if (throwable3 != null) {
                    try {
                        ((ZipInputStream)zip).close();
                    }
                    catch (Throwable buffer) {
                        throwable3.addSuppressed(buffer);
                    }
                } else {
                    ((ZipInputStream)zip).close();
                }
            }
        }
        Path modulesPath = this.homePath.resolve("modules");
        if (modulesPath.toFile().isDirectory()) {
            Properties properties = new Properties();
            Path layersPath = modulesPath.resolve("layers.conf");
            if (layersPath.toFile().isFile()) {
                FileReader fr = new FileReader(layersPath.toFile());
                path = null;
                try {
                    properties.load(fr);
                }
                catch (Throwable file) {
                    path = file;
                    throw file;
                }
                finally {
                    if (fr != null) {
                        if (path != null) {
                            try {
                                fr.close();
                            }
                            catch (Throwable file) {
                                ((Throwable)path).addSuppressed(file);
                            }
                        } else {
                            fr.close();
                        }
                    }
                }
            }
            ArrayList<String> layers = new ArrayList<String>();
            String value = properties.getProperty("layers");
            if (value != null) {
                for (String layer : value.split(",")) {
                    layers.add(layer.trim());
                }
            }
            if (!layers.contains(FUSE_LAYER)) {
                layers.add(0, FUSE_LAYER);
                value = "";
                for (String layer : layers) {
                    value = value + "," + layer;
                }
                value = value.substring(1);
                properties.setProperty("layers", value);
                PatchLogger.warn("Layers config does not contain 'fuse', writing: " + value);
                try (FileWriter fw = new FileWriter(layersPath.toFile());){
                    properties.store(fw, "Fixed by fusepatch");
                }
            }
        }
    }

    private Path getWorkspace() {
        return this.homePath.resolve(Paths.get("fusepatch", "workspace"));
    }

    static Path getConfiguredHomePath() {
        Path currpath;
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            jbossHome = System.getProperty("jboss.home.dir");
        }
        if (jbossHome == null) {
            jbossHome = System.getenv("JBOSS_HOME");
        }
        if (jbossHome == null && (currpath = Paths.get(".", new String[0])).resolve("jboss-modules.jar").toFile().exists()) {
            jbossHome = currpath.toAbsolutePath().toString();
        }
        return jbossHome != null ? Paths.get(jbossHome, new String[0]) : null;
    }
}

