/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.ManagedPath;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.Server;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.ManagedPaths;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.utils.IOUtils;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

final class WildFlyServer
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(WildFlyServer.class);
    private static final String FUSE_LAYER = "fuse";
    private final Path homePath;

    WildFlyServer(Path homePath) {
        if (homePath == null) {
            homePath = WildFlyServer.getConfiguredHomePath();
        }
        IllegalStateAssertion.assertNotNull(homePath, "Cannot obtain JBOSS_HOME");
        IllegalStateAssertion.assertTrue(homePath.toFile().isDirectory(), "Directory JBOSS_HOME does not exist: " + homePath);
        this.homePath = homePath.toAbsolutePath();
    }

    @Override
    public Path getDefaultRepositoryPath() {
        return this.homePath.resolve(Paths.get("fusepatch", "repository"));
    }

    @Override
    public Path getServerHome() {
        return this.homePath;
    }

    @Override
    public List<PatchId> queryAppliedPackages() {
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.queryAppliedPackages(this.getWorkspace(), null, true);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public List<ManagedPath> queryManagedPaths(String pattern) {
        Lock.tryLock();
        try {
            List<ManagedPath> list = Parser.queryManagedPaths(this.getWorkspace(), pattern);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.queryAppliedPackages(this.getWorkspace(), prefix, true);
            Package package_ = list.isEmpty() ? null : this.getPackage(list.get(0));
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public List<String> getAuditLog() {
        Lock.tryLock();
        try {
            List<String> list = Parser.readAuditLog(this.getWorkspace());
            return list;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public Package getPackage(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            Package package_ = Parser.readPackage(this.getWorkspace(), patchId);
            return package_;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Package applySmartPatch(SmartPatch smartPatch, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(smartPatch, "smartPatch");
        if (smartPatch.getRecords().isEmpty()) {
            LOG.warn("Patch {} has already been applied", (Object)smartPatch.getPatchId());
            return null;
        }
        Lock.tryLock();
        try {
            void var10_27;
            Package infoset;
            List<PatchId> appliedPatches = this.queryAppliedPackages();
            ArrayList<PatchId> unsatisfied = new ArrayList<PatchId>();
            for (PatchId depId : smartPatch.getDependencies()) {
                if (appliedPatches.contains(depId)) continue;
                unsatisfied.add(depId);
            }
            PatchAssertion.assertTrue(unsatisfied.isEmpty(), "Unsatisfied dependencies: " + unsatisfied);
            PatchId patchId = smartPatch.getPatchId();
            Package serverSet = this.getPackage(patchId.getName());
            PatchId serverId = serverSet != null ? serverSet.getPatchId() : null;
            HashMap<Path, Record> serverRecords = new HashMap<Path, Record>();
            if (serverSet != null) {
                for (Record record : serverSet.getRecords()) {
                    serverRecords.put(record.getPath(), record);
                }
            }
            for (Record record : smartPatch.getRemoveSet()) {
                Path path = this.getServerHome().resolve(record.getPath());
                if (!path.toFile().exists()) {
                    LOG.warn("Attempt to delete a non existing file: {}", (Object)record.getPath());
                }
                serverRecords.remove(record.getPath());
            }
            for (Record record : smartPatch.getReplaceSet()) {
                Long wasCheck;
                Record exprec;
                Long expcheck;
                Path path = this.getServerHome().resolve(record.getPath());
                String filename = path.getFileName().toString();
                if (!path.toFile().exists()) {
                    LOG.warn("Attempt to replace a non existing file: ", (Object)record.getPath());
                } else if ((filename.endsWith(".xml") || filename.endsWith(".properties")) && !(expcheck = Long.valueOf((exprec = (Record)serverRecords.get(record.getPath())) != null ? exprec.getChecksum() : 0L)).equals(wasCheck = Long.valueOf(IOUtils.getCRC32(path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to override an already modified file " + record.getPath());
                    LOG.warn("Overriding an already modified file: ", (Object)record.getPath());
                }
                serverRecords.put(record.getPath(), record);
            }
            for (Record record : smartPatch.getAddSet()) {
                Long wasCheck;
                Long expcheck;
                Path path = this.getServerHome().resolve(record.getPath());
                if (path.toFile().exists() && !(expcheck = record.getChecksum()).equals(wasCheck = Long.valueOf(IOUtils.getCRC32(path)))) {
                    PatchAssertion.assertTrue(force, "Attempt to add an already existing file " + record.getPath());
                    LOG.warn("Overriding an already existing file: ", (Object)record.getPath());
                }
                serverRecords.put(record.getPath(), record);
            }
            this.updateServerFiles(smartPatch);
            this.updateManagedPaths(smartPatch);
            if (!smartPatch.isUninstall()) {
                if (serverId != null && serverId.compareTo(patchId) > 0) {
                    for (PatchId patchId2 : Parser.queryAppliedPackages(this.getWorkspace(), patchId.getName(), false)) {
                        if (patchId2.compareTo(patchId) <= 0) continue;
                        File packageDir = Parser.getMetadataDirectory(this.getWorkspace(), patchId2).getParentFile();
                        IOUtils.rmdirs(packageDir.toPath());
                    }
                }
                HashSet<Record> hashSet = new HashSet<Record>();
                for (Record rec : serverRecords.values()) {
                    hashSet.add(Record.create(rec.getPath(), rec.getChecksum()));
                }
                infoset = Package.create(patchId, hashSet);
                Parser.writePackage(this.getWorkspace(), infoset);
            } else {
                infoset = Package.create(patchId, smartPatch.getRecords());
                File file = Parser.getMetadataDirectory(this.getWorkspace(), patchId).getParentFile();
                IOUtils.rmdirs(file.toPath());
            }
            if (serverId == null) {
                String string = "Installed " + patchId;
            } else if (serverId.compareTo(patchId) < 0) {
                String string = "Upgraded from " + serverId + " to " + patchId;
            } else if (serverId.compareTo(patchId) == 0) {
                if (smartPatch.isUninstall()) {
                    String string = "Uninstalled " + patchId;
                } else {
                    String string = "Reinstalled " + patchId;
                }
            } else {
                String string = "Downgraded from " + serverId + " to " + patchId;
            }
            Parser.writeAuditLog(this.getWorkspace(), (String)var10_27, smartPatch);
            LOG.info((String)var10_27);
            if (!smartPatch.isUninstall()) {
                Runtime runtime = Runtime.getRuntime();
                File procdir = this.homePath.toFile();
                for (String cmd : smartPatch.getPostCommands()) {
                    LOG.info("Run: {}", (Object)cmd);
                    String[] cmdarr = cmd.split("\\s");
                    Process proc = runtime.exec(cmdarr, null, procdir);
                    try {
                        this.startStreaming(proc.getInputStream(), System.out);
                        this.startStreaming(proc.getErrorStream(), System.err);
                        if (proc.waitFor() == 0) continue;
                        LOG.error("Command did not terminate normally: " + cmd);
                        break;
                    }
                    catch (InterruptedException ex) {
                    }
                }
            }
            Package package_ = infoset;
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    private Thread startStreaming(final InputStream input, final OutputStream output) {
        Thread thread = new Thread("io"){

            @Override
            public void run() {
                try {
                    IOUtils.copy(input, output);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        return thread;
    }

    private void updateServerFiles(SmartPatch smartPatch) throws IOException {
        Path modulesPath;
        Object path;
        Object zip;
        HashSet<Path> addupdPaths = new HashSet<Path>();
        for (Record record : smartPatch.getAddSet()) {
            addupdPaths.add(record.getPath());
        }
        for (Record record : smartPatch.getReplaceSet()) {
            addupdPaths.add(record.getPath());
        }
        if (!smartPatch.isUninstall()) {
            zip = this.getZipInputStream(smartPatch);
            Throwable throwable = null;
            try {
                ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        Path path2 = Paths.get(entry.getName(), new String[0]);
                        addupdPaths.remove(path2);
                    }
                    entry = ((ZipInputStream)zip).getNextEntry();
                }
            }
            catch (Throwable entry) {
                Throwable throwable2 = entry;
                throw entry;
            }
            finally {
                if (zip != null) {
                    if (throwable != null) {
                        try {
                            ((ZipInputStream)zip).close();
                        }
                        catch (Throwable entry) {
                            throwable.addSuppressed(entry);
                        }
                    } else {
                        ((ZipInputStream)zip).close();
                    }
                }
            }
        }
        IllegalStateAssertion.assertTrue(addupdPaths.isEmpty(), "Patch file does not contain expected paths: " + addupdPaths);
        for (Record record : smartPatch.getRemoveSet()) {
            Path path3 = this.getServerHome().resolve(record.getPath());
            Files.deleteIfExists(path3);
        }
        if (!smartPatch.isUninstall()) {
            zip = this.getZipInputStream(smartPatch);
            Throwable throwable = null;
            try {
                byte[] buffer = new byte[1024];
                ZipEntry entry = ((ZipInputStream)zip).getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory() && (smartPatch.isReplacePath((Path)(path = Paths.get(entry.getName(), new String[0]))) || smartPatch.isAddPath((Path)path))) {
                        String[] file = this.homePath.resolve((Path)path).toFile();
                        file.getParentFile().mkdirs();
                        try (FileOutputStream fos = new FileOutputStream((File)file);){
                            int read = ((FilterInputStream)zip).read(buffer);
                            while (read > 0) {
                                fos.write(buffer, 0, read);
                                read = ((FilterInputStream)zip).read(buffer);
                            }
                        }
                        if (file.getName().endsWith(".sh") || file.getName().endsWith(".bat")) {
                            file.setExecutable(true);
                        }
                    }
                    entry = ((ZipInputStream)zip).getNextEntry();
                }
            }
            catch (Throwable buffer) {
                Throwable throwable3 = buffer;
                throw buffer;
            }
            finally {
                if (zip != null) {
                    if (throwable != null) {
                        try {
                            ((ZipInputStream)zip).close();
                        }
                        catch (Throwable buffer) {
                            throwable.addSuppressed(buffer);
                        }
                    } else {
                        ((ZipInputStream)zip).close();
                    }
                }
            }
        }
        if ((modulesPath = this.homePath.resolve("modules")).toFile().isDirectory()) {
            Properties properties = new Properties();
            Path layersPath = modulesPath.resolve("layers.conf");
            if (layersPath.toFile().isFile()) {
                FileReader fr = new FileReader(layersPath.toFile());
                path = null;
                try {
                    properties.load(fr);
                }
                catch (Throwable file) {
                    path = file;
                    throw file;
                }
                finally {
                    if (fr != null) {
                        if (path != null) {
                            try {
                                fr.close();
                            }
                            catch (Throwable file) {
                                ((Throwable)path).addSuppressed(file);
                            }
                        } else {
                            fr.close();
                        }
                    }
                }
            }
            ArrayList<String> layers = new ArrayList<String>();
            String value = properties.getProperty("layers");
            if (value != null) {
                for (String layer : value.split(",")) {
                    layers.add(layer.trim());
                }
            }
            if (!layers.contains(FUSE_LAYER)) {
                layers.add(0, FUSE_LAYER);
                value = "";
                for (String layer : layers) {
                    value = value + "," + layer;
                }
                value = value.substring(1);
                properties.setProperty("layers", value);
                LOG.warn("Layers config does not contain 'fuse', writing: {}", (Object)value);
                try (FileWriter fw = new FileWriter(layersPath.toFile());){
                    properties.store(fw, "Fixed by fusepatch");
                }
            }
        }
    }

    private void updateManagedPaths(SmartPatch smartPatch) throws IOException {
        ManagedPaths managedPaths = Parser.readManagedPaths(this.getWorkspace());
        Parser.writeManagedPaths(this.getWorkspace(), managedPaths.updatePaths(smartPatch));
    }

    private ZipInputStream getZipInputStream(SmartPatch smartPatch) throws IOException {
        URL patchURL = smartPatch.getPatchURL();
        IllegalStateAssertion.assertEquals("file", patchURL.getProtocol(), "Usupported protocol: " + patchURL);
        return new ZipInputStream(patchURL.openStream());
    }

    private Path getWorkspace() {
        return this.homePath.resolve(Paths.get("fusepatch", "workspace"));
    }

    static Path getConfiguredHomePath() {
        Path currpath;
        String jbossHome = System.getProperty("jboss.home");
        if (jbossHome == null) {
            jbossHome = System.getProperty("jboss.home.dir");
        }
        if (jbossHome == null) {
            jbossHome = System.getenv("JBOSS_HOME");
        }
        if (jbossHome == null && (currpath = Paths.get(".", new String[0])).resolve("jboss-modules.jar").toFile().exists()) {
            jbossHome = currpath.toAbsolutePath().toString();
        }
        return jbossHome != null ? Paths.get(jbossHome, new String[0]) : null;
    }

    public String toString() {
        return "WildFlyServer[home=" + this.homePath + "]";
    }
}

